/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import io.cloudevents.CloudEvent;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.SendMessageContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessageProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private final EventMeshGrpcServer eventMeshGrpcServer;

    public RequestMessageProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void process(final SimpleMessage message, final EventEmitter<SimpleMessage> emitter) throws Exception {
        RequestHeader requestHeader = message.getHeader();
        if (!ServiceUtils.validateHeader(requestHeader)) {
            ServiceUtils.sendStreamRespAndDone(message.getHeader(), StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateMessage(message)) {
            ServiceUtils.sendStreamRespAndDone(message.getHeader(), StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        final String seqNum = message.getSeqNum();
        final String uniqueId = message.getUniqueId();
        final String topic = message.getTopic();
        String producerGroup = message.getProducerGroup();
        int ttl = Integer.parseInt(message.getTtl());
        try {
            this.doAclCheck(message);
        }
        catch (Exception e) {
            this.aclLogger.warn("CLIENT HAS NO PERMISSION,RequestReplyMessageProcessor send failed", (Throwable)e);
            ServiceUtils.sendStreamRespAndDone(message.getHeader(), StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        if (!this.eventMeshGrpcServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            this.logger.error("Send message speed over limit.");
            ServiceUtils.sendStreamRespAndDone(message.getHeader(), StatusCode.EVENTMESH_SEND_MESSAGE_SPEED_OVER_LIMIT_ERR, emitter);
            return;
        }
        String protocolType = requestHeader.getProtocolType();
        final ProtocolAdaptor grpcCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent cloudEvent = grpcCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)new SimpleMessageWrapper(message));
        ProducerManager producerManager = this.eventMeshGrpcServer.getProducerManager();
        EventMeshProducer eventMeshProducer = producerManager.getEventMeshProducer(producerGroup);
        SendMessageContext sendMessageContext = new SendMessageContext(message.getSeqNum(), cloudEvent, eventMeshProducer, this.eventMeshGrpcServer);
        final long startTime = System.currentTimeMillis();
        eventMeshProducer.request(sendMessageContext, new RequestReplyCallback(){

            public void onSuccess(CloudEvent event) {
                try {
                    SimpleMessageWrapper wrapper = (SimpleMessageWrapper)grpcCommandProtocolAdaptor.fromCloudEvent(event);
                    emitter.onNext(wrapper.getMessage());
                    emitter.onCompleted();
                    long endTime = System.currentTimeMillis();
                    RequestMessageProcessor.this.logger.info("message|eventmesh2client|REPLY|RequestReply|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId});
                }
                catch (Exception e) {
                    ServiceUtils.sendStreamRespAndDone(message.getHeader(), StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR, EventMeshUtil.stackTrace(e, 2), emitter);
                    long endTime = System.currentTimeMillis();
                    RequestMessageProcessor.this.logger.error("message|mq2eventmesh|REPLY|RequestReply|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId, e});
                }
            }

            public void onException(Throwable e) {
                ServiceUtils.sendStreamRespAndDone(message.getHeader(), StatusCode.EVENTMESH_REQUEST_REPLY_MSG_ERR, EventMeshUtil.stackTrace(e, 2), emitter);
                long endTime = System.currentTimeMillis();
                RequestMessageProcessor.this.logger.error("message|eventMesh2mq|REPLY|RequestReply|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId, e});
            }
        }, ttl);
    }

    private void doAclCheck(SimpleMessage message) throws AclException {
        RequestHeader requestHeader = message.getHeader();
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshServerSecurityEnable) {
            String remoteAdd = requestHeader.getIp();
            String user = requestHeader.getUsername();
            String pass = requestHeader.getPassword();
            String subsystem = requestHeader.getSys();
            String topic = message.getTopic();
            Acl.doAclCheckInHttpSend(remoteAdd, user, pass, subsystem, topic, RequestCode.MSG_SEND_ASYNC.getRequestCode());
        }
    }
}

