/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.plugin;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.api.factory.ConnectorPluginFactory;
import org.apache.eventmesh.runtime.core.plugin.MQWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQConsumerWrapper
extends MQWrapper {
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Consumer meshMQPushConsumer;

    public MQConsumerWrapper(String connectorPluginType) {
        this.meshMQPushConsumer = ConnectorPluginFactory.getMeshMQPushConsumer((String)connectorPluginType);
        if (this.meshMQPushConsumer == null) {
            this.logger.error("can't load the meshMQPushConsumer plugin, please check.");
            throw new RuntimeException("doesn't load the meshMQPushConsumer plugin, please check.");
        }
    }

    public void subscribe(String topic) throws Exception {
        this.meshMQPushConsumer.subscribe(topic);
    }

    public void unsubscribe(String topic) throws Exception {
        this.meshMQPushConsumer.unsubscribe(topic);
    }

    public synchronized void init(Properties keyValue) throws Exception {
        this.meshMQPushConsumer.init(keyValue);
        this.inited.compareAndSet(false, true);
    }

    public synchronized void start() throws Exception {
        this.meshMQPushConsumer.start();
        this.started.compareAndSet(false, true);
    }

    public synchronized void shutdown() throws Exception {
        this.meshMQPushConsumer.shutdown();
        this.inited.compareAndSet(false, true);
        this.started.compareAndSet(false, true);
    }

    public void registerEventListener(EventListener listener) {
        this.meshMQPushConsumer.registerEventListener(listener);
    }

    public void updateOffset(List<CloudEvent> events, AbstractContext eventMeshConsumeConcurrentlyContext) {
        this.meshMQPushConsumer.updateOffset(events, eventMeshConsumeConcurrentlyContext);
    }
}

