/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.runtime.boot.AbstractHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.boot.HTTPTrace;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AdminMetricsProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.BatchSendMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.BatchSendMessageV2Processor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HeartBeatProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.LocalSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.LocalUnSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.RemoteSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.RemoteUnSubscribeEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.ReplyMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendAsyncRemoteEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SendSyncMessageProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.SubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.UnSubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.WebHookProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.http.push.HTTPClientPool;
import org.apache.eventmesh.runtime.core.protocol.http.retry.HttpRetryer;
import org.apache.eventmesh.runtime.metrics.http.HTTPMetricsServer;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.eventmesh.webhook.receive.WebHookController;
import org.assertj.core.util.Lists;

public class EventMeshHTTPServer
extends AbstractHTTPServer {
    private EventMeshServer eventMeshServer;
    public ServiceState serviceState;
    private EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private Registry registry;
    public final ConcurrentHashMap<String, ConsumerGroupConf> localConsumerGroupMapping = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, List<Client>> localClientInfoMapping = new ConcurrentHashMap();
    public EventBus eventBus = new EventBus();
    private ConsumerManager consumerManager;
    private ProducerManager producerManager;
    private HttpRetryer httpRetryer;
    public ThreadPoolExecutor batchMsgExecutor;
    public ThreadPoolExecutor sendMsgExecutor;
    public ThreadPoolExecutor remoteMsgExecutor;
    public ThreadPoolExecutor replyMsgExecutor;
    public ThreadPoolExecutor pushMsgExecutor;
    public ThreadPoolExecutor clientManageExecutor;
    public ThreadPoolExecutor adminExecutor;
    public ThreadPoolExecutor webhookExecutor;
    private RateLimiter msgRateLimiter;
    private RateLimiter batchRateLimiter;
    public HTTPClientPool httpClientPool = new HTTPClientPool(10);

    public EventMeshHTTPServer(EventMeshServer eventMeshServer, EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        super(eventMeshHttpConfiguration.httpServerPort, eventMeshHttpConfiguration.eventMeshServerUseTls, eventMeshHttpConfiguration);
        this.eventMeshServer = eventMeshServer;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        this.registry = eventMeshServer.getRegistry();
    }

    public EventMeshServer getEventMeshServer() {
        return this.eventMeshServer;
    }

    public void shutdownThreadPool() throws Exception {
        this.batchMsgExecutor.shutdown();
        this.adminExecutor.shutdown();
        this.clientManageExecutor.shutdown();
        this.sendMsgExecutor.shutdown();
        this.remoteMsgExecutor.shutdown();
        this.pushMsgExecutor.shutdown();
        this.replyMsgExecutor.shutdown();
    }

    public void initThreadPool() throws Exception {
        LinkedBlockingQueue batchMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshHttpConfiguration.eventMeshServerBatchBlockQSize);
        this.batchMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerBatchMsgThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerBatchMsgThreadNum, batchMsgThreadPoolQueue, (String)"eventMesh-batchMsg-", (boolean)true);
        LinkedBlockingQueue sendMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshHttpConfiguration.eventMeshServerSendMsgBlockQSize);
        this.sendMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerSendMsgThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerSendMsgThreadNum, sendMsgThreadPoolQueue, (String)"eventMesh-sendMsg-", (boolean)true);
        LinkedBlockingQueue remoteMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshHttpConfiguration.eventMeshServerRemoteMsgBlockQSize);
        this.remoteMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerRemoteMsgThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerRemoteMsgThreadNum, remoteMsgThreadPoolQueue, (String)"eventMesh-remoteMsg-", (boolean)true);
        LinkedBlockingQueue pushMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshHttpConfiguration.eventMeshServerPushMsgBlockQSize);
        this.pushMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerPushMsgThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerPushMsgThreadNum, pushMsgThreadPoolQueue, (String)"eventMesh-pushMsg-", (boolean)true);
        LinkedBlockingQueue clientManageThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshHttpConfiguration.eventMeshServerClientManageBlockQSize);
        this.clientManageExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerClientManageThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerClientManageThreadNum, clientManageThreadPoolQueue, (String)"eventMesh-clientManage-", (boolean)true);
        LinkedBlockingQueue adminThreadPoolQueue = new LinkedBlockingQueue(50);
        this.adminExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerAdminThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerAdminThreadNum, adminThreadPoolQueue, (String)"eventMesh-admin-", (boolean)true);
        LinkedBlockingQueue replyMessageThreadPoolQueue = new LinkedBlockingQueue(100);
        this.replyMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerReplyMsgThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerReplyMsgThreadNum, replyMessageThreadPoolQueue, (String)"eventMesh-replyMsg-", (boolean)true);
    }

    public ThreadPoolExecutor getBatchMsgExecutor() {
        return this.batchMsgExecutor;
    }

    public ThreadPoolExecutor getSendMsgExecutor() {
        return this.sendMsgExecutor;
    }

    public ThreadPoolExecutor getReplyMsgExecutor() {
        return this.replyMsgExecutor;
    }

    public ThreadPoolExecutor getPushMsgExecutor() {
        return this.pushMsgExecutor;
    }

    public ThreadPoolExecutor getClientManageExecutor() {
        return this.clientManageExecutor;
    }

    public ThreadPoolExecutor getAdminExecutor() {
        return this.adminExecutor;
    }

    public RateLimiter getMsgRateLimiter() {
        return this.msgRateLimiter;
    }

    public RateLimiter getBatchRateLimiter() {
        return this.batchRateLimiter;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void init() throws Exception {
        this.logger.info("==================EventMeshHTTPServer Initialing==================");
        super.init("eventMesh-http");
        this.initThreadPool();
        this.msgRateLimiter = RateLimiter.create((double)this.eventMeshHttpConfiguration.eventMeshHttpMsgReqNumPerSecond);
        this.batchRateLimiter = RateLimiter.create((double)this.eventMeshHttpConfiguration.eventMeshBatchMsgRequestNumPerSecond);
        ArrayList metricsRegistries = Lists.newArrayList();
        Optional.ofNullable(this.eventMeshHttpConfiguration.eventMeshMetricsPluginType).ifPresent(metricsPlugins -> metricsPlugins.forEach(pluginType -> metricsRegistries.add(MetricsPluginFactory.getMetricsRegistry((String)pluginType))));
        this.httpRetryer = new HttpRetryer(this);
        this.httpRetryer.init();
        this.metrics = new HTTPMetricsServer(this, metricsRegistries);
        this.metrics.init();
        this.consumerManager = new ConsumerManager(this);
        this.consumerManager.init();
        this.producerManager = new ProducerManager(this);
        this.producerManager.init();
        this.handlerService = new HandlerService();
        this.handlerService.setMetrics(this.metrics);
        if (StringUtils.isNotEmpty((CharSequence)this.eventMeshHttpConfiguration.eventMeshTracePluginType) && this.eventMeshHttpConfiguration.eventMeshServerTraceEnable) {
            this.useTrace = this.eventMeshHttpConfiguration.eventMeshServerTraceEnable;
        }
        this.handlerService.setHttpTrace(new HTTPTrace(this.eventMeshHttpConfiguration.eventMeshServerTraceEnable));
        this.registerHTTPRequestProcessor();
        this.initWebhook();
        this.logger.info("--------------------------EventMeshHTTPServer inited");
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.metrics.start();
        this.consumerManager.start();
        this.producerManager.start();
        this.httpRetryer.start();
        if (this.eventMeshHttpConfiguration.eventMeshServerRegistryEnable) {
            this.register();
        }
        this.logger.info("--------------------------EventMeshHTTPServer started");
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.metrics.shutdown();
        this.consumerManager.shutdown();
        this.shutdownThreadPool();
        this.httpClientPool.shutdown();
        this.producerManager.shutdown();
        this.httpRetryer.shutdown();
        if (this.eventMeshHttpConfiguration.eventMeshServerRegistryEnable) {
            this.unRegister();
        }
        this.logger.info("--------------------------EventMeshHTTPServer shutdown");
    }

    public boolean register() {
        boolean registerResult = false;
        try {
            String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshHttpConfiguration.httpServerPort;
            EventMeshRegisterInfo eventMeshRegisterInfo = new EventMeshRegisterInfo();
            eventMeshRegisterInfo.setEventMeshClusterName(this.eventMeshHttpConfiguration.eventMeshCluster);
            eventMeshRegisterInfo.setEventMeshName(this.eventMeshHttpConfiguration.eventMeshName + "-" + "HTTP");
            eventMeshRegisterInfo.setEndPoint(endPoints);
            eventMeshRegisterInfo.setProtocolType("HTTP");
            registerResult = this.registry.register(eventMeshRegisterInfo);
        }
        catch (Exception e) {
            this.logger.warn("eventMesh register to registry failed", (Throwable)e);
        }
        return registerResult;
    }

    private void unRegister() throws Exception {
        String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshHttpConfiguration.httpServerPort;
        EventMeshUnRegisterInfo eventMeshUnRegisterInfo = new EventMeshUnRegisterInfo();
        eventMeshUnRegisterInfo.setEventMeshClusterName(this.eventMeshHttpConfiguration.eventMeshCluster);
        eventMeshUnRegisterInfo.setEventMeshName(this.eventMeshHttpConfiguration.eventMeshName);
        eventMeshUnRegisterInfo.setEndPoint(endPoints);
        eventMeshUnRegisterInfo.setProtocolType("HTTP");
        boolean registerResult = this.registry.unRegister(eventMeshUnRegisterInfo);
        if (!registerResult) {
            throw new EventMeshException("eventMesh fail to unRegister");
        }
    }

    public void registerHTTPRequestProcessor() {
        BatchSendMessageProcessor batchSendMessageProcessor = new BatchSendMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_BATCH_SEND.getRequestCode(), batchSendMessageProcessor, this.batchMsgExecutor);
        BatchSendMessageV2Processor batchSendMessageV2Processor = new BatchSendMessageV2Processor(this);
        this.registerProcessor(RequestCode.MSG_BATCH_SEND_V2.getRequestCode(), batchSendMessageV2Processor, this.batchMsgExecutor);
        SendSyncMessageProcessor sendSyncMessageProcessor = new SendSyncMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_SEND_SYNC.getRequestCode(), sendSyncMessageProcessor, this.sendMsgExecutor);
        SendAsyncMessageProcessor sendAsyncMessageProcessor = new SendAsyncMessageProcessor(this);
        this.registerProcessor(RequestCode.MSG_SEND_ASYNC.getRequestCode(), sendAsyncMessageProcessor, this.sendMsgExecutor);
        SendAsyncEventProcessor sendAsyncEventProcessor = new SendAsyncEventProcessor(this);
        this.handlerService.register(sendAsyncEventProcessor, this.sendMsgExecutor);
        SendAsyncRemoteEventProcessor sendAsyncRemoteEventProcessor = new SendAsyncRemoteEventProcessor(this);
        this.handlerService.register(sendAsyncRemoteEventProcessor, this.remoteMsgExecutor);
        AdminMetricsProcessor adminMetricsProcessor = new AdminMetricsProcessor(this);
        this.registerProcessor(RequestCode.ADMIN_METRICS.getRequestCode(), adminMetricsProcessor, this.adminExecutor);
        HeartBeatProcessor heartProcessor = new HeartBeatProcessor(this);
        this.registerProcessor(RequestCode.HEARTBEAT.getRequestCode(), heartProcessor, this.clientManageExecutor);
        SubscribeProcessor subscribeProcessor = new SubscribeProcessor(this);
        this.registerProcessor(RequestCode.SUBSCRIBE.getRequestCode(), subscribeProcessor, this.clientManageExecutor);
        LocalSubscribeEventProcessor localSubscribeEventProcessor = new LocalSubscribeEventProcessor(this);
        this.handlerService.register(localSubscribeEventProcessor, this.clientManageExecutor);
        RemoteSubscribeEventProcessor remoteSubscribeEventProcessor = new RemoteSubscribeEventProcessor(this);
        this.handlerService.register(remoteSubscribeEventProcessor, this.clientManageExecutor);
        UnSubscribeProcessor unSubscribeProcessor = new UnSubscribeProcessor(this);
        this.registerProcessor(RequestCode.UNSUBSCRIBE.getRequestCode(), unSubscribeProcessor, this.clientManageExecutor);
        LocalUnSubscribeEventProcessor localUnSubscribeEventProcessor = new LocalUnSubscribeEventProcessor(this);
        this.handlerService.register(localUnSubscribeEventProcessor, this.clientManageExecutor);
        RemoteUnSubscribeEventProcessor remoteUnSubscribeEventProcessor = new RemoteUnSubscribeEventProcessor(this);
        this.handlerService.register(remoteUnSubscribeEventProcessor, this.clientManageExecutor);
        ReplyMessageProcessor replyMessageProcessor = new ReplyMessageProcessor(this);
        this.registerProcessor(RequestCode.REPLY_MESSAGE.getRequestCode(), replyMessageProcessor, this.replyMsgExecutor);
    }

    private void initWebhook() throws Exception {
        LinkedBlockingQueue webhookThreadPoolQueue = new LinkedBlockingQueue(100);
        this.webhookExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshHttpConfiguration.eventMeshServerWebhookThreadNum, (int)this.eventMeshHttpConfiguration.eventMeshServerWebhookThreadNum, webhookThreadPoolQueue, (String)"eventMesh-webhook-", (boolean)true);
        WebHookProcessor webHookProcessor = new WebHookProcessor();
        WebHookController webHookController = new WebHookController();
        webHookController.setConfigurationWrapper(this.eventMeshHttpConfiguration.getConfigurationWrapper());
        webHookController.init();
        webHookProcessor.setWebHookController(webHookController);
        this.handlerService.register(webHookProcessor, this.webhookExecutor);
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public EventMeshHTTPConfiguration getEventMeshHttpConfiguration() {
        return this.eventMeshHttpConfiguration;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public HttpRetryer getHttpRetryer() {
        return this.httpRetryer;
    }
}

