/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.boot.SSLContextFactory;
import org.apache.eventmesh.runtime.common.Pair;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.EventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.metrics.http.HTTPMetricsServer;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTPServer
extends AbstractRemotingServer {
    public Logger httpServerLogger = LoggerFactory.getLogger(this.getClass());
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    protected HandlerService handlerService;
    public HTTPMetricsServer metrics;
    public DefaultHttpDataFactory defaultHttpDataFactory = new DefaultHttpDataFactory(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private boolean useTLS;
    public Boolean useTrace = false;
    private EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    public ThreadPoolExecutor asyncContextCompleteHandler = ThreadPoolFactory.createThreadPoolExecutor((int)10, (int)10, (String)"EventMesh-http-asyncContext-");
    protected final Map<String, Pair<HttpRequestProcessor, ThreadPoolExecutor>> processorTable = new HashMap<String, Pair<HttpRequestProcessor, ThreadPoolExecutor>>(64);
    protected final Map<String, Pair<EventProcessor, ThreadPoolExecutor>> eventProcessorTable = new HashMap<String, Pair<EventProcessor, ThreadPoolExecutor>>(64);

    public AbstractHTTPServer(int port, boolean useTLS, EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        this.port = port;
        this.useTLS = useTLS;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
    }

    public void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpHeaders responseHeaders = response.headers();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)String.format("text/plain; charset=%s", "UTF-8"));
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        responseHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendResponse(ChannelHandlerContext ctx, DefaultFullHttpResponse response) {
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                this.httpLogger.warn("send response to [{}] fail, will close this channel", (Object)RemotingHelper.parseChannelRemoteAddr(f.channel()));
                f.channel().close();
            }
        }));
    }

    @Override
    public void start() throws Exception {
        super.start();
        Runnable r = () -> {
            ServerBootstrap b = new ServerBootstrap();
            SSLContext sslContext = this.useTLS ? SSLContextFactory.getSslContext() : null;
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpsServerInitializer(sslContext)).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
            try {
                this.httpServerLogger.info("HTTPServer[port={}] started......", (Object)this.port);
                ChannelFuture future = b.bind(this.port).sync();
                future.channel().closeFuture().sync();
            }
            catch (Exception e) {
                this.httpServerLogger.error("HTTPServer start Err!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception e1) {
                    this.httpServerLogger.error("HTTPServer shutdown Err!", (Throwable)e);
                }
            }
        };
        Thread t = new Thread(r, "EventMesh-http-server");
        t.start();
        this.started.compareAndSet(false, true);
    }

    @Override
    public void init(String threadPrefix) throws Exception {
        super.init(threadPrefix);
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.started.compareAndSet(true, false);
    }

    public void registerProcessor(Integer requestCode, HttpRequestProcessor processor, ThreadPoolExecutor executor) {
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{requestCode}), (Object)"requestCode can't be null");
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{processor}), (Object)"processor can't be null");
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{executor}), (Object)"executor can't be null");
        Pair<HttpRequestProcessor, ThreadPoolExecutor> pair = new Pair<HttpRequestProcessor, ThreadPoolExecutor>(processor, executor);
        this.processorTable.put(requestCode.toString(), pair);
    }

    public void registerProcessor(String requestURI, EventProcessor processor, ThreadPoolExecutor executor) {
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{requestURI}), (Object)"requestURI can't be null");
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{processor}), (Object)"processor can't be null");
        Preconditions.checkState((boolean)ObjectUtils.allNotNull((Object[])new Object[]{executor}), (Object)"executor can't be null");
        Pair<EventProcessor, ThreadPoolExecutor> pair = new Pair<EventProcessor, ThreadPoolExecutor>(processor, executor);
        this.eventProcessorTable.put(requestURI, pair);
    }

    private Map<String, Object> parseHttpHeader(HttpRequest fullReq) {
        HashMap<String, Object> headerParam = new HashMap<String, Object>();
        for (String key : fullReq.headers().names()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_TYPE.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.ACCEPT_ENCODING.toString(), (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)HttpHeaderNames.CONTENT_LENGTH.toString(), (CharSequence)key)) continue;
            headerParam.put(key, fullReq.headers().get(key));
        }
        return headerParam;
    }

    private HttpResponseStatus validateHttpRequest(HttpRequest httpRequest) {
        if (!this.started.get()) {
            return HttpResponseStatus.SERVICE_UNAVAILABLE;
        }
        if (!httpRequest.decoderResult().isSuccess()) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (!HttpMethod.GET.equals((Object)httpRequest.method()) && !HttpMethod.POST.equals((Object)httpRequest.method())) {
            return HttpResponseStatus.METHOD_NOT_ALLOWED;
        }
        String protocolVersion = httpRequest.headers().get("version");
        if (!ProtocolVersion.contains((String)protocolVersion)) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        return null;
    }

    private void preProcessHttpRequestHeader(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        long startTime = System.currentTimeMillis();
        HttpHeaders requestHeaders = httpRequest.headers();
        requestHeaders.set("ip", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
        String protocolVersion = httpRequest.headers().get("version");
        if (StringUtils.isBlank((CharSequence)protocolVersion)) {
            requestHeaders.set("version", (Object)ProtocolVersion.V1.getVersion());
        }
        requestHeaders.set("reqc2eventmeshtimestamp", (Object)startTime);
        requestHeaders.set("reqsendeventmeship", (Object)this.eventMeshHttpConfiguration.eventMeshServerIp);
    }

    private Map<String, Object> parseHttpRequestBody(HttpRequest httpRequest) throws IOException {
        long bodyDecodeStart = System.currentTimeMillis();
        HashMap<String, Object> httpRequestBody = new HashMap<String, Object>();
        if (HttpMethod.GET.equals((Object)httpRequest.method())) {
            QueryStringDecoder getDecoder = new QueryStringDecoder(httpRequest.uri());
            getDecoder.parameters().forEach((key, value) -> httpRequestBody.put((String)key, value.get(0)));
        } else if (HttpMethod.POST.equals((Object)httpRequest.method())) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)this.defaultHttpDataFactory, httpRequest);
            for (InterfaceHttpData parm : decoder.getBodyHttpDatas()) {
                if (parm.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                Attribute data = (Attribute)parm;
                httpRequestBody.put(data.getName(), data.getValue());
            }
            decoder.destroy();
        }
        this.metrics.getSummaryMetrics().recordDecodeTimeCost(System.currentTimeMillis() - bodyDecodeStart);
        return httpRequestBody;
    }

    private HttpEventWrapper parseHttpRequest(HttpRequest httpRequest) throws IOException {
        HttpEventWrapper httpEventWrapper = new HttpEventWrapper();
        httpEventWrapper.setHttpMethod(httpRequest.method().name());
        httpEventWrapper.setHttpVersion(httpRequest.protocolVersion().protocolName());
        httpEventWrapper.setRequestURI(httpRequest.uri());
        for (String key2 : httpRequest.headers().names()) {
            httpEventWrapper.getHeaderMap().put(key2, httpRequest.headers().get(key2));
        }
        long bodyDecodeStart = System.currentTimeMillis();
        FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        if (HttpMethod.GET == fullHttpRequest.method()) {
            QueryStringDecoder getDecoder = new QueryStringDecoder(fullHttpRequest.uri());
            getDecoder.parameters().forEach((key, value) -> bodyMap.put((String)key, (String)value.get(0)));
        } else if (HttpMethod.POST == fullHttpRequest.method()) {
            if (StringUtils.contains((CharSequence)httpRequest.headers().get("Content-Type"), (CharSequence)ContentType.APPLICATION_JSON.getMimeType())) {
                int length = fullHttpRequest.content().readableBytes();
                if (length > 0) {
                    byte[] body = new byte[length];
                    fullHttpRequest.content().readBytes(body);
                    ((Map)JsonUtils.deserialize((String)new String(body), (TypeReference)new TypeReference<Map<String, Object>>(){})).forEach(bodyMap::put);
                }
            } else {
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)this.defaultHttpDataFactory, httpRequest);
                for (InterfaceHttpData parm : decoder.getBodyHttpDatas()) {
                    if (parm.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                    Attribute data = (Attribute)parm;
                    bodyMap.put(data.getName(), data.getValue());
                }
                decoder.destroy();
            }
        } else {
            throw new RuntimeException("UnSupported Method " + fullHttpRequest.method());
        }
        byte[] requestBody = JsonUtils.serialize(bodyMap).getBytes(StandardCharsets.UTF_8);
        httpEventWrapper.setBody(requestBody);
        this.metrics.getSummaryMetrics().recordDecodeTimeCost(System.currentTimeMillis() - bodyDecodeStart);
        return httpEventWrapper;
    }

    static {
        DiskAttribute.deleteOnExitTemporaryFile = false;
    }

    class HttpsServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final SSLContext sslContext;

        public HttpsServerInitializer(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        protected void initChannel(SocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            if (this.sslContext != null && AbstractHTTPServer.this.useTLS) {
                SSLEngine sslEngine = this.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(false);
                pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine));
            }
            pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder(), new HttpConnectionHandler(), new HttpObjectAggregator(Integer.MAX_VALUE), new HTTPHandler()});
        }
    }

    class HttpConnectionHandler
    extends ChannelDuplexHandler {
        public final AtomicInteger connections = new AtomicInteger(0);

        HttpConnectionHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            super.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            super.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            int c = this.connections.incrementAndGet();
            if (c > 20000) {
                AbstractHTTPServer.this.httpServerLogger.warn("client|http|channelActive|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)"too many client(20000) connect this eventMesh server");
                ctx.close();
                return;
            }
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.connections.decrementAndGet();
            super.channelInactive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                AbstractHTTPServer.this.httpServerLogger.info("client|http|userEventTriggered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)evt.getClass().getName());
                ctx.close();
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    class HTTPHandler
    extends ChannelInboundHandlerAdapter {
        HTTPHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object message) {
            block17: {
                HttpRequest httpRequest = (HttpRequest)message;
                if (Objects.nonNull(AbstractHTTPServer.this.handlerService) && AbstractHTTPServer.this.handlerService.isProcessorWrapper(httpRequest)) {
                    AbstractHTTPServer.this.handlerService.handler(ctx, httpRequest, AbstractHTTPServer.this.asyncContextCompleteHandler);
                    return;
                }
                try {
                    Span span = null;
                    AbstractHTTPServer.this.preProcessHttpRequestHeader(ctx, httpRequest);
                    Map headerMap = AbstractHTTPServer.this.parseHttpHeader(httpRequest);
                    HttpResponseStatus errorStatus = AbstractHTTPServer.this.validateHttpRequest(httpRequest);
                    if (errorStatus != null) {
                        AbstractHTTPServer.this.sendError(ctx, errorStatus);
                        span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                        TraceUtils.finishSpanWithException(span, headerMap, errorStatus.reasonPhrase(), null);
                        return;
                    }
                    AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPRequest();
                    boolean useRequestURI = false;
                    for (String processURI : AbstractHTTPServer.this.eventProcessorTable.keySet()) {
                        if (!httpRequest.uri().startsWith(processURI)) continue;
                        useRequestURI = true;
                        break;
                    }
                    if (useRequestURI) {
                        if (AbstractHTTPServer.this.useTrace.booleanValue()) {
                            span.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)httpRequest.method().name());
                            span.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)httpRequest.protocolVersion().protocolName());
                            span.setAttribute(SemanticAttributes.HTTP_URL, (Object)httpRequest.uri());
                        }
                        HttpEventWrapper httpEventWrapper = AbstractHTTPServer.this.parseHttpRequest(httpRequest);
                        AsyncContext<Object> asyncContext = new AsyncContext<Object>(httpEventWrapper, null, AbstractHTTPServer.this.asyncContextCompleteHandler);
                        this.processHttpRequest(ctx, asyncContext);
                        break block17;
                    }
                    HttpCommand requestCommand = new HttpCommand();
                    Map bodyMap = AbstractHTTPServer.this.parseHttpRequestBody(httpRequest);
                    String requestCode = httpRequest.method() == HttpMethod.POST ? httpRequest.headers().get("code") : MapUtils.getString((Map)bodyMap, (Object)StringUtils.lowerCase((String)"code"), (String)"");
                    requestCommand.setHttpMethod(httpRequest.method().name());
                    requestCommand.setHttpVersion(httpRequest.protocolVersion().protocolName());
                    requestCommand.setRequestCode(requestCode);
                    HttpCommand responseCommand = null;
                    if (StringUtils.isBlank((CharSequence)requestCode) || !AbstractHTTPServer.this.processorTable.containsKey(requestCode) || !RequestCode.contains((Integer)Integer.valueOf(requestCode))) {
                        responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID);
                        AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                        span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                        TraceUtils.finishSpanWithException(span, headerMap, EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID.getErrMsg(), null);
                        return;
                    }
                    try {
                        requestCommand.setHeader(Header.buildHeader((String)requestCode, (Map)headerMap));
                        requestCommand.setBody(Body.buildBody((String)requestCode, (Map)bodyMap));
                    }
                    catch (Exception e) {
                        responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_RUNTIME_ERR);
                        AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                        span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                        TraceUtils.finishSpanWithException(span, headerMap, EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg(), (Throwable)e);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    if (AbstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                        AbstractHTTPServer.this.httpLogger.debug("{}", (Object)requestCommand);
                    }
                    AsyncContext<HttpCommand> asyncContext = new AsyncContext<HttpCommand>(requestCommand, responseCommand, AbstractHTTPServer.this.asyncContextCompleteHandler);
                    this.processEventMeshRequest(ctx, asyncContext);
                }
                catch (Exception ex) {
                    AbstractHTTPServer.this.httpServerLogger.error("AbrstractHTTPServer.HTTPHandler.channelRead err", (Throwable)ex);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
            }
        }

        public void processHttpRequest(ChannelHandlerContext ctx, AsyncContext<HttpEventWrapper> asyncContext) {
            HttpEventWrapper requestWrapper = asyncContext.getRequest();
            String requestURI = requestWrapper.getRequestURI();
            String processorKey = "/";
            for (String eventProcessorKey : AbstractHTTPServer.this.eventProcessorTable.keySet()) {
                if (!requestURI.startsWith(eventProcessorKey)) continue;
                processorKey = eventProcessorKey;
                break;
            }
            Pair<EventProcessor, ThreadPoolExecutor> choosed = AbstractHTTPServer.this.eventProcessorTable.get(processorKey);
            try {
                choosed.getObject2().submit(() -> {
                    try {
                        EventProcessor processor = (EventProcessor)choosed.getObject1();
                        if (processor.rejectRequest()) {
                            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR);
                            asyncContext.onComplete(responseWrapper);
                            if (asyncContext.isComplete()) {
                                if (AbstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                                    AbstractHTTPServer.this.httpLogger.debug("{}", asyncContext.getResponse());
                                }
                                AbstractHTTPServer.this.sendResponse(ctx, ((HttpEventWrapper)asyncContext.getResponse()).httpResponse());
                            }
                            return;
                        }
                        processor.processRequest(ctx, asyncContext);
                        if (!asyncContext.isComplete()) {
                            return;
                        }
                        AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                        if (AbstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                            AbstractHTTPServer.this.httpLogger.debug("{}", asyncContext.getResponse());
                        }
                        AbstractHTTPServer.this.sendResponse(ctx, ((HttpEventWrapper)asyncContext.getResponse()).httpResponse());
                    }
                    catch (Exception e) {
                        AbstractHTTPServer.this.httpServerLogger.error("process error", (Throwable)e);
                    }
                });
            }
            catch (RejectedExecutionException re) {
                HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(EventMeshRetCode.OVERLOAD);
                asyncContext.onComplete(responseWrapper);
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPDiscard();
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                try {
                    AbstractHTTPServer.this.sendResponse(ctx, asyncContext.getResponse().httpResponse());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void processEventMeshRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) {
            HttpCommand request = asyncContext.getRequest();
            Pair<HttpRequestProcessor, ThreadPoolExecutor> choosed = AbstractHTTPServer.this.processorTable.get(request.getRequestCode());
            try {
                choosed.getObject2().submit(() -> {
                    try {
                        HttpRequestProcessor processor = (HttpRequestProcessor)choosed.getObject1();
                        if (processor.rejectRequest()) {
                            HttpCommand responseCommand = request.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR);
                            asyncContext.onComplete(responseCommand);
                            if (asyncContext.isComplete()) {
                                if (AbstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                                    AbstractHTTPServer.this.httpLogger.debug("{}", asyncContext.getResponse());
                                }
                                AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                                Map traceMap = ((HttpCommand)asyncContext.getRequest()).getHeader().toMap();
                                Span span = TraceUtils.prepareServerSpan(traceMap, "upstream-eventmesh-server-span", false);
                                TraceUtils.finishSpanWithException(span, traceMap, EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR.getErrMsg(), null);
                            }
                            return;
                        }
                        processor.processRequest(ctx, asyncContext);
                        if (!asyncContext.isComplete()) {
                            return;
                        }
                        AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                        if (AbstractHTTPServer.this.httpLogger.isDebugEnabled()) {
                            AbstractHTTPServer.this.httpLogger.debug("{}", asyncContext.getResponse());
                        }
                        AbstractHTTPServer.this.sendResponse(ctx, ((HttpCommand)asyncContext.getResponse()).httpResponse());
                    }
                    catch (Exception e) {
                        AbstractHTTPServer.this.httpServerLogger.error("process error", (Throwable)e);
                    }
                });
            }
            catch (RejectedExecutionException re) {
                HttpCommand responseCommand = request.createHttpCommandResponse(EventMeshRetCode.OVERLOAD);
                asyncContext.onComplete(responseCommand);
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPDiscard();
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                try {
                    AbstractHTTPServer.this.sendResponse(ctx, asyncContext.getResponse().httpResponse());
                    Map traceMap = asyncContext.getRequest().getHeader().toMap();
                    Span span = TraceUtils.prepareServerSpan(traceMap, "upstream-eventmesh-server-span", false);
                    TraceUtils.finishSpanWithException(span, traceMap, EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg(), (Throwable)re);
                }
                catch (Exception e) {
                    AbstractHTTPServer.this.httpServerLogger.error("processEventMeshRequest fail", (Throwable)re);
                }
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            super.channelReadComplete(ctx);
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (null != cause) {
                AbstractHTTPServer.this.logger.error("", cause);
            }
            if (null != ctx) {
                ctx.close();
            }
        }

        Map<String, String> extractFromRequest(HttpRequest httpRequest) {
            return null;
        }
    }
}

