/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.eventmesh.admin.rocketmq.util.JsonUtils;
import org.apache.eventmesh.admin.rocketmq.util.NetUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWebHookConfigByIdHandler
implements HttpHandler {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebHookConfigOperation operation;

    public QueryWebHookConfigByIdHandler(WebHookConfigOperation operation) {
        this.operation = operation;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        httpExchange.sendResponseHeaders(200, 0L);
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        String requestBody = NetUtils.parsePostBody((HttpExchange)httpExchange);
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.toObject((String)requestBody, WebHookConfig.class);
        try (OutputStream out = httpExchange.getResponseBody();){
            WebHookConfig result = this.operation.queryWebHookConfigById(webHookConfig);
            out.write(JsonUtils.toJson((Object)result).getBytes());
        }
        catch (Exception e) {
            this.logger.error("get WebHookConfigOperation implementation Failed.", (Throwable)e);
        }
    }
}

