/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendImpl;
import org.apache.eventmesh.runtime.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRecommendEventMeshHandler
implements HttpHandler {
    private Logger logger = LoggerFactory.getLogger(QueryRecommendEventMeshHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public QueryRecommendEventMeshHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        OutputStream out = httpExchange.getResponseBody();
        try {
            if (!this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerRegistryEnable) {
                throw new Exception("registry enable config is false, not support");
            }
            String queryString = httpExchange.getRequestURI().getQuery();
            Map<String, String> queryStringInfo = NetUtils.formData2Dic(queryString);
            String group = queryStringInfo.get("group");
            String purpose = queryStringInfo.get("purpose");
            if (StringUtils.isBlank((CharSequence)group) || StringUtils.isBlank((CharSequence)purpose)) {
                httpExchange.sendResponseHeaders(200, 0L);
                result = "params illegal!";
                out.write(result.getBytes());
                return;
            }
            EventMeshRecommendImpl eventMeshRecommendStrategy = new EventMeshRecommendImpl(this.eventMeshTCPServer);
            String recommendEventMeshResult = eventMeshRecommendStrategy.calculateRecommendEventMesh(group, purpose);
            result = recommendEventMeshResult == null ? "null" : recommendEventMeshResult;
            this.logger.info("recommend eventmesh:{},group:{},purpose:{}", new Object[]{result, group, purpose});
            httpExchange.sendResponseHeaders(200, 0L);
            out.write(result.getBytes());
        }
        catch (Exception e) {
            this.logger.error("QueryRecommendEventMeshHandler fail...", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }
}

