/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.eventmesh.admin.rocketmq.util.JsonUtils;
import org.apache.eventmesh.admin.rocketmq.util.NetUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteWebHookConfigHandler
implements HttpHandler {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebHookConfigOperation operation;

    public DeleteWebHookConfigHandler(WebHookConfigOperation operation) {
        this.operation = operation;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        httpExchange.sendResponseHeaders(200, 0L);
        String requestBody = NetUtils.parsePostBody((HttpExchange)httpExchange);
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.toObject((String)requestBody, WebHookConfig.class);
        try (OutputStream out = httpExchange.getResponseBody();){
            Integer code = this.operation.deleteWebHookConfig(webHookConfig);
            String result = 1 == code ? "deleteWebHookConfig Succeed!" : "deleteWebHookConfig Failed!";
            out.write(result.getBytes());
        }
        catch (Exception e) {
            this.logger.error("get WebHookConfigOperation implementation Failed.", (Throwable)e);
        }
    }
}

