/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.cloudevents;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.common.BatchMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;
import org.apache.eventmesh.protocol.cloudevents.resolver.grpc.GrpcMessageProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.http.SendMessageBatchProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.http.SendMessageBatchV2ProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.http.SendMessageRequestProtocolResolver;
import org.apache.eventmesh.protocol.cloudevents.resolver.tcp.TcpMessageProtocolResolver;

public class CloudEventsProtocolAdaptor<T extends ProtocolTransportObject>
implements ProtocolAdaptor<ProtocolTransportObject> {
    public CloudEvent toCloudEvent(ProtocolTransportObject cloudEvent) throws ProtocolHandleException {
        if (cloudEvent instanceof Package) {
            Package tcpPackage = (Package)cloudEvent;
            Header header = tcpPackage.getHeader();
            String cloudEventJson = tcpPackage.getBody().toString();
            return this.deserializeTcpProtocol(header, cloudEventJson);
        }
        if (cloudEvent instanceof HttpCommand) {
            org.apache.eventmesh.common.protocol.http.header.Header header = ((HttpCommand)cloudEvent).getHeader();
            Body body = ((HttpCommand)cloudEvent).getBody();
            String requestCode = ((HttpCommand)cloudEvent).getRequestCode();
            return this.deserializeHttpProtocol(requestCode, header, body);
        }
        if (cloudEvent instanceof SimpleMessageWrapper) {
            SimpleMessage simpleMessage = ((SimpleMessageWrapper)cloudEvent).getMessage();
            return GrpcMessageProtocolResolver.buildEvent(simpleMessage);
        }
        throw new ProtocolHandleException(String.format("protocol class: %s", cloudEvent.getClass()));
    }

    private CloudEvent deserializeTcpProtocol(Header header, String cloudEventJson) throws ProtocolHandleException {
        return TcpMessageProtocolResolver.buildEvent(header, cloudEventJson);
    }

    private CloudEvent deserializeHttpProtocol(String requestCode, org.apache.eventmesh.common.protocol.http.header.Header header, Body body) throws ProtocolHandleException {
        if (String.valueOf(RequestCode.MSG_BATCH_SEND.getRequestCode()).equals(requestCode)) {
            return SendMessageBatchProtocolResolver.buildEvent(header, body);
        }
        if (String.valueOf(RequestCode.MSG_BATCH_SEND_V2.getRequestCode()).equals(requestCode)) {
            return SendMessageBatchV2ProtocolResolver.buildEvent(header, body);
        }
        if (String.valueOf(RequestCode.MSG_SEND_SYNC.getRequestCode()).equals(requestCode)) {
            return SendMessageRequestProtocolResolver.buildEvent(header, body);
        }
        if (String.valueOf(RequestCode.MSG_SEND_ASYNC.getRequestCode()).equals(requestCode)) {
            return SendMessageRequestProtocolResolver.buildEvent(header, body);
        }
        throw new ProtocolHandleException(String.format("unsupported requestCode: %s", requestCode));
    }

    public List<CloudEvent> toBatchCloudEvent(ProtocolTransportObject protocol) throws ProtocolHandleException {
        if (protocol instanceof BatchMessageWrapper) {
            BatchMessage batchMessage = ((BatchMessageWrapper)protocol).getMessage();
            return GrpcMessageProtocolResolver.buildBatchEvents(batchMessage);
        }
        throw new ProtocolHandleException(String.format("protocol class: %s", protocol.getClass()));
    }

    public ProtocolTransportObject fromCloudEvent(final CloudEvent cloudEvent) throws ProtocolHandleException {
        String protocolDesc = cloudEvent.getExtension("protocoldesc").toString();
        if (StringUtils.equals((CharSequence)"http", (CharSequence)protocolDesc)) {
            HttpCommand httpCommand = new HttpCommand();
            Body body = new Body(){
                final Map<String, Object> map = new HashMap<String, Object>();

                public Map<String, Object> toMap() {
                    byte[] eventByte = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").serialize(cloudEvent);
                    this.map.put("content", new String(eventByte, StandardCharsets.UTF_8));
                    return this.map;
                }
            };
            body.toMap();
            httpCommand.setBody(body);
            return httpCommand;
        }
        if (StringUtils.equals((CharSequence)"tcp", (CharSequence)protocolDesc)) {
            Package pkg = new Package();
            String dataContentType = cloudEvent.getDataContentType();
            Preconditions.checkNotNull((Object)dataContentType, (Object)"DateContentType cannot be null");
            EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat(dataContentType);
            Preconditions.checkNotNull((Object)eventFormat, (Object)String.format("DateContentType:%s is not supported", dataContentType));
            pkg.setBody((Object)eventFormat.serialize(cloudEvent));
            return pkg;
        }
        if (StringUtils.equals((CharSequence)"grpc", (CharSequence)protocolDesc)) {
            return GrpcMessageProtocolResolver.buildSimpleMessage(cloudEvent);
        }
        throw new ProtocolHandleException(String.format("Unsupported protocolDesc: %s", protocolDesc));
    }

    public String getProtocolType() {
        return "cloudevents";
    }
}

