/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.api.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSummaryMetrics
implements Metric {
    private static final Logger log = LoggerFactory.getLogger(HttpSummaryMetrics.class);
    private static final int STATIC_PERIOD = 30000;
    public static final String EVENTMESH_MONITOR_FORMAT_HTTP = "{\"maxHTTPTPS\":\"%.1f\",\"avgHTTPTPS\":\"%.1f\",\"maxHTTPCOST\":\"%s\",\"avgHTTPCOST\":\"%.1f\",\"avgHTTPBodyDecodeCost\":\"%.1f\", \"httpDiscard\":\"%s\"}";
    private float wholeCost = 0.0f;
    private AtomicLong wholeRequestNum = new AtomicLong(0L);
    private AtomicLong httpDiscard = new AtomicLong(0L);
    private AtomicLong maxCost = new AtomicLong(0L);
    private AtomicLong httpRequestPerSecond = new AtomicLong(0L);
    private LinkedList<Integer> httpRequestTPSSnapshots = new LinkedList();
    private float httpDecodeTimeCost = 0.0f;
    private AtomicLong httpDecodeNum = new AtomicLong(0L);
    public static final String EVENTMESH_MONITOR_FORMAT_BATCHSENDMSG = "{\"maxBatchSendMsgTPS\":\"%.1f\",\"avgBatchSendMsgTPS\":\"%.1f\", \"sum\":\"%s\", \"sumFail\":\"%s\", \"sumFailRate\":\"%.2f\", \"discard\":\"%s\"}";
    private AtomicLong sendBatchMsgNumPerSecond = new AtomicLong(0L);
    private AtomicLong sendBatchMsgNumSum = new AtomicLong(0L);
    private AtomicLong sendBatchMsgFailNumSum = new AtomicLong(0L);
    private AtomicLong sendBatchMsgDiscardNumSum = new AtomicLong(0L);
    private LinkedList<Integer> sendBatchMsgTPSSnapshots = new LinkedList();
    public static final String EVENTMESH_MONITOR_FORMAT_SENDMSG = "{\"maxSendMsgTPS\":\"%.1f\",\"avgSendMsgTPS\":\"%.1f\", \"sum\":\"%s\", \"sumFail\":\"%s\", \"sumFailRate\":\"%.2f\", \"replyMsg\":\"%s\", \"replyFail\":\"%s\"}";
    private AtomicLong sendMsgNumSum = new AtomicLong(0L);
    private AtomicLong sendMsgFailNumSum = new AtomicLong(0L);
    private AtomicLong replyMsgNumSum = new AtomicLong(0L);
    private AtomicLong replyMsgFailNumSum = new AtomicLong(0L);
    private AtomicLong sendMsgNumPerSecond = new AtomicLong(0L);
    private LinkedList<Integer> sendMsgTPSSnapshots = new LinkedList();
    public static final String EVENTMESH_MONITOR_FORMAT_PUSHMSG = "{\"maxPushMsgTPS\":\"%.1f\",\"avgPushMsgTPS\":\"%.1f\", \"sum\":\"%s\", \"sumFail\":\"%s\", \"sumFailRate\":\"%.1f\", \"maxClientLatency\":\"%.1f\", \"avgClientLatency\":\"%.1f\"}";
    private float wholePushCost = 0.0f;
    private AtomicLong wholePushRequestNum = new AtomicLong(0L);
    private AtomicLong maxHttpPushLatency = new AtomicLong(0L);
    private AtomicLong pushMsgNumPerSecond = new AtomicLong(0L);
    private LinkedList<Integer> pushMsgTPSSnapshots = new LinkedList();
    private AtomicLong httpPushMsgNumSum = new AtomicLong(0L);
    private AtomicLong httpPushFailNumSum = new AtomicLong(0L);
    public static final String EVENTMESH_MONITOR_FORMAT_BLOCKQ = "{\"batchMsgQ\":\"%s\",\"sendMsgQ\":\"%s\",\"pushMsgQ\":\"%s\",\"httpRetryQ\":\"%s\"}";
    public static final String EVENTMESH_MONITOR_FORMAT_MQ_CLIENT = "{\"batchAvgSend2MQCost\":\"%.1f\", \"avgSend2MQCost\":\"%.1f\", \"avgReply2MQCost\":\"%.1f\"}";
    private float batchSend2MQWholeCost = 0.0f;
    private AtomicLong batchSend2MQNum = new AtomicLong(0L);
    private float send2MQWholeCost = 0.0f;
    private AtomicLong send2MQNum = new AtomicLong(0L);
    private float reply2MQWholeCost = 0.0f;
    private AtomicLong reply2MQNum = new AtomicLong(0L);
    private final ThreadPoolExecutor batchMsgExecutor;
    private final ThreadPoolExecutor sendMsgExecutor;
    private final ThreadPoolExecutor pushMsgExecutor;
    private final DelayQueue<?> httpFailedQueue;

    public HttpSummaryMetrics(ThreadPoolExecutor batchMsgExecutor, ThreadPoolExecutor sendMsgExecutor, ThreadPoolExecutor pushMsgExecutor, DelayQueue<?> httpFailedQueue) {
        this.batchMsgExecutor = batchMsgExecutor;
        this.sendMsgExecutor = sendMsgExecutor;
        this.pushMsgExecutor = pushMsgExecutor;
        this.httpFailedQueue = httpFailedQueue;
    }

    public float avgHTTPCost() {
        float cost = this.wholeRequestNum.longValue() == 0L ? 0.0f : this.wholeCost / (float)this.wholeRequestNum.longValue();
        return cost;
    }

    public long maxHTTPCost() {
        long cost = this.maxCost.longValue();
        return cost;
    }

    public long getHttpDiscard() {
        return this.httpDiscard.longValue();
    }

    public void recordHTTPRequest() {
        this.httpRequestPerSecond.incrementAndGet();
    }

    public void recordHTTPDiscard() {
        this.httpDiscard.incrementAndGet();
    }

    public void snapshotHTTPTPS() {
        Integer tps = this.httpRequestPerSecond.intValue();
        this.httpRequestTPSSnapshots.add(tps);
        this.httpRequestPerSecond.set(0L);
        if (this.httpRequestTPSSnapshots.size() > 30) {
            this.httpRequestTPSSnapshots.removeFirst();
        }
    }

    public float maxHTTPTPS() {
        float tps = Collections.max(this.httpRequestTPSSnapshots).intValue();
        return tps;
    }

    public float avgHTTPTPS() {
        float tps = this.avg(this.httpRequestTPSSnapshots);
        return tps;
    }

    public void recordHTTPReqResTimeCost(long cost) {
        this.wholeRequestNum.incrementAndGet();
        this.wholeCost += (float)cost;
        if (cost > this.maxCost.longValue()) {
            this.maxCost.set(cost);
        }
    }

    public void httpStatInfoClear() {
        this.wholeRequestNum.set(0L);
        this.wholeCost = 0.0f;
        this.maxCost.set(0L);
        this.httpDecodeNum.set(0L);
        this.httpDecodeTimeCost = 0.0f;
    }

    public void recordDecodeTimeCost(long cost) {
        this.httpDecodeNum.incrementAndGet();
        this.httpDecodeTimeCost += (float)cost;
    }

    public float avgHTTPBodyDecodeCost() {
        float cost = this.httpDecodeNum.longValue() == 0L ? 0.0f : this.httpDecodeTimeCost / (float)this.httpDecodeNum.longValue();
        return cost;
    }

    public void recordSendBatchMsgDiscard(long delta) {
        this.sendBatchMsgDiscardNumSum.addAndGet(delta);
    }

    public void snapshotSendBatchMsgTPS() {
        Integer tps = this.sendBatchMsgNumPerSecond.intValue();
        this.sendBatchMsgTPSSnapshots.add(tps);
        this.sendBatchMsgNumPerSecond.set(0L);
        if (this.sendBatchMsgTPSSnapshots.size() > 30) {
            this.sendBatchMsgTPSSnapshots.removeFirst();
        }
    }

    public float maxSendBatchMsgTPS() {
        float tps = Collections.max(this.sendBatchMsgTPSSnapshots).intValue();
        return tps;
    }

    public float avgSendBatchMsgTPS() {
        float tps = this.avg(this.sendBatchMsgTPSSnapshots);
        return tps;
    }

    public void recordSendBatchMsg(long delta) {
        this.sendBatchMsgNumPerSecond.addAndGet(delta);
        this.sendBatchMsgNumSum.addAndGet(delta);
    }

    public void recordSendBatchMsgFailed(long delta) {
        this.sendBatchMsgFailNumSum.getAndAdd(delta);
    }

    public long getSendBatchMsgNumSum() {
        return this.sendBatchMsgNumSum.longValue();
    }

    public long getSendBatchMsgFailNumSum() {
        return this.sendBatchMsgFailNumSum.longValue();
    }

    public float getSendBatchMsgFailRate() {
        return this.sendBatchMsgNumSum.longValue() == 0L ? 0.0f : this.sendBatchMsgFailNumSum.floatValue() / (float)this.sendBatchMsgNumSum.longValue();
    }

    public void cleanSendBatchStat() {
        this.sendBatchMsgNumSum.set(0L);
        this.sendBatchMsgFailNumSum.set(0L);
    }

    public long getSendBatchMsgDiscardNumSum() {
        return this.sendBatchMsgDiscardNumSum.longValue();
    }

    public void snapshotSendMsgTPS() {
        Integer tps = this.sendMsgNumPerSecond.intValue();
        this.sendMsgTPSSnapshots.add(tps);
        this.sendMsgNumPerSecond.set(0L);
        if (this.sendMsgTPSSnapshots.size() > 30) {
            this.sendMsgTPSSnapshots.removeFirst();
        }
    }

    public float maxSendMsgTPS() {
        float tps = Collections.max(this.sendMsgTPSSnapshots).intValue();
        return tps;
    }

    public float avgSendMsgTPS() {
        float tps = this.avg(this.sendMsgTPSSnapshots);
        return tps;
    }

    public void recordSendMsg() {
        this.sendMsgNumPerSecond.incrementAndGet();
        this.sendMsgNumSum.incrementAndGet();
    }

    public void recordReplyMsg() {
        this.replyMsgNumSum.incrementAndGet();
    }

    public void recordReplyMsgFailed() {
        this.replyMsgFailNumSum.incrementAndGet();
    }

    public long getReplyMsgNumSum() {
        return this.replyMsgNumSum.longValue();
    }

    public long getReplyMsgFailNumSum() {
        return this.replyMsgFailNumSum.longValue();
    }

    public long getSendMsgNumSum() {
        return this.sendMsgNumSum.longValue();
    }

    public long getSendMsgFailNumSum() {
        return this.sendMsgFailNumSum.longValue();
    }

    public float getSendMsgFailRate() {
        return this.sendMsgNumSum.longValue() == 0L ? 0.0f : this.sendMsgFailNumSum.floatValue() / (float)this.sendMsgNumSum.longValue();
    }

    public void recordSendMsgFailed() {
        this.sendMsgFailNumSum.incrementAndGet();
    }

    public void cleanSendMsgStat() {
        this.sendMsgNumSum.set(0L);
        this.replyMsgNumSum.set(0L);
        this.sendMsgFailNumSum.set(0L);
        this.replyMsgFailNumSum.set(0L);
    }

    public void snapshotPushMsgTPS() {
        Integer tps = this.pushMsgNumPerSecond.intValue();
        this.pushMsgTPSSnapshots.add(tps);
        this.pushMsgNumPerSecond.set(0L);
        if (this.pushMsgTPSSnapshots.size() > 30) {
            this.pushMsgTPSSnapshots.removeFirst();
        }
    }

    public void recordHTTPPushTimeCost(long cost) {
        this.wholePushRequestNum.incrementAndGet();
        this.wholePushCost += (float)cost;
        if (cost > this.maxHttpPushLatency.longValue()) {
            this.maxHttpPushLatency.set(cost);
        }
    }

    public float avgHTTPPushLatency() {
        return this.wholePushRequestNum.longValue() == 0L ? 0.0f : this.wholePushCost / (float)this.wholePushRequestNum.longValue();
    }

    public float maxHTTPPushLatency() {
        return this.maxHttpPushLatency.floatValue();
    }

    public float maxPushMsgTPS() {
        float tps = Collections.max(this.pushMsgTPSSnapshots).intValue();
        return tps;
    }

    public float avgPushMsgTPS() {
        float tps = this.avg(this.pushMsgTPSSnapshots);
        return tps;
    }

    public void recordPushMsg() {
        this.pushMsgNumPerSecond.incrementAndGet();
        this.httpPushMsgNumSum.incrementAndGet();
    }

    public long getHttpPushMsgNumSum() {
        return this.httpPushMsgNumSum.longValue();
    }

    public long getHttpPushFailNumSum() {
        return this.httpPushFailNumSum.longValue();
    }

    public float getHttpPushMsgFailRate() {
        return this.httpPushMsgNumSum.longValue() == 0L ? 0.0f : this.httpPushFailNumSum.floatValue() / (float)this.httpPushMsgNumSum.longValue();
    }

    public void recordHttpPushMsgFailed() {
        this.sendMsgFailNumSum.incrementAndGet();
    }

    public void cleanHttpPushMsgStat() {
        this.httpPushFailNumSum.set(0L);
        this.httpPushMsgNumSum.set(0L);
        this.wholeRequestNum.set(0L);
        this.wholeCost = 0.0f;
        this.maxCost.set(0L);
    }

    public void recordBatchSendMsgCost(long cost) {
        this.batchSend2MQNum.incrementAndGet();
        this.batchSend2MQWholeCost += (float)cost;
    }

    public float avgBatchSendMsgCost() {
        float cost = this.batchSend2MQNum.intValue() == 0 ? 0.0f : this.batchSend2MQWholeCost / (float)this.batchSend2MQNum.intValue();
        return cost;
    }

    public void recordSendMsgCost(long cost) {
        this.send2MQNum.incrementAndGet();
        this.send2MQWholeCost += (float)cost;
    }

    public float avgSendMsgCost() {
        float cost = this.send2MQNum.intValue() == 0 ? 0.0f : this.send2MQWholeCost / (float)this.send2MQNum.intValue();
        return cost;
    }

    public void recordReplyMsgCost(long cost) {
        this.reply2MQNum.incrementAndGet();
        this.reply2MQWholeCost += (float)cost;
    }

    public float avgReplyMsgCost() {
        float cost = this.reply2MQNum.intValue() == 0 ? 0.0f : this.reply2MQWholeCost / (float)this.reply2MQNum.intValue();
        return cost;
    }

    public void send2MQStatInfoClear() {
        this.batchSend2MQWholeCost = 0.0f;
        this.batchSend2MQNum.set(0L);
        this.send2MQWholeCost = 0.0f;
        this.send2MQNum.set(0L);
        this.reply2MQWholeCost = 0.0f;
        this.reply2MQNum.set(0L);
    }

    public int getBatchMsgQueueSize() {
        return this.batchMsgExecutor.getQueue().size();
    }

    public int getSendMsgQueueSize() {
        return this.sendMsgExecutor.getQueue().size();
    }

    public int getPushMsgQueueSize() {
        return this.pushMsgExecutor.getQueue().size();
    }

    public int getHttpRetryQueueSize() {
        return this.httpFailedQueue.size();
    }

    private float avg(LinkedList<Integer> linkedList) {
        if (linkedList.isEmpty()) {
            return 0.0f;
        }
        int sum = (Integer)linkedList.stream().reduce(Integer::sum).get();
        return (float)sum / (float)linkedList.size();
    }
}

