/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.zipkin;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.eventmesh.trace.api.EventMeshTraceService;
import org.apache.eventmesh.trace.api.config.ExporterConfiguration;
import org.apache.eventmesh.trace.api.exception.TraceException;
import org.apache.eventmesh.trace.zipkin.config.ZipkinConfiguration;

public class ZipkinTraceService
implements EventMeshTraceService {
    private String eventMeshZipkinIP;
    private int eventMeshZipkinPort;
    private int eventMeshTraceExportInterval;
    private int eventMeshTraceExportTimeout;
    private int eventMeshTraceMaxExportSize;
    private int eventMeshTraceMaxQueueSize;
    protected SdkTracerProvider sdkTracerProvider;
    protected OpenTelemetry openTelemetry;
    protected Thread shutdownHook;
    private Tracer tracer;
    private TextMapPropagator textMapPropagator;

    public void init() {
        this.eventMeshZipkinIP = ZipkinConfiguration.getEventMeshZipkinIP();
        this.eventMeshZipkinPort = ZipkinConfiguration.getEventMeshZipkinPort();
        this.eventMeshTraceExportInterval = ExporterConfiguration.getEventMeshTraceExportInterval();
        this.eventMeshTraceExportTimeout = ExporterConfiguration.getEventMeshTraceExportTimeout();
        this.eventMeshTraceMaxExportSize = ExporterConfiguration.getEventMeshTraceMaxExportSize();
        this.eventMeshTraceMaxQueueSize = ExporterConfiguration.getEventMeshTraceMaxQueueSize();
        String httpUrl = String.format("http://%s:%s", this.eventMeshZipkinIP, this.eventMeshZipkinPort);
        ZipkinSpanExporter zipkinExporter = ZipkinSpanExporter.builder().setEndpoint(httpUrl + "/api/v2/spans").build();
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)zipkinExporter).setScheduleDelay((long)this.eventMeshTraceExportInterval, TimeUnit.SECONDS).setExporterTimeout((long)this.eventMeshTraceExportTimeout, TimeUnit.SECONDS).setMaxExportBatchSize(this.eventMeshTraceMaxExportSize).setMaxQueueSize(this.eventMeshTraceMaxQueueSize).build();
        Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"eventmesh_trace"));
        this.sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)spanProcessor).setResource(Resource.getDefault().merge(serviceNameResource)).build();
        this.openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(this.sdkTracerProvider).build();
        this.tracer = this.openTelemetry.getTracer("eventmesh_trace");
        this.textMapPropagator = this.openTelemetry.getPropagators().getTextMapPropagator();
        this.shutdownHook = new Thread(() -> ((SdkTracerProvider)this.sdkTracerProvider).close());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public Context extractFrom(Context context, Map<String, Object> map) throws TraceException {
        this.textMapPropagator.extract(context, map, (TextMapGetter)new TextMapGetter<Map<String, Object>>(){

            public Iterable<String> keys(Map<String, Object> carrier) {
                return carrier.keySet();
            }

            public String get(Map<String, Object> carrier, String key) {
                return carrier.get(key).toString();
            }
        });
        return context;
    }

    public void inject(Context context, final Map<String, Object> map) {
        this.textMapPropagator.inject(context, map, (TextMapSetter)new TextMapSetter<Map<String, Object>>(){

            public void set(@Nullable Map<String, Object> carrier, String key, String value) {
                map.put(key, value);
            }
        });
    }

    public Span createSpan(String spanName, SpanKind spanKind, long startTime, TimeUnit timeUnit, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(startTime, timeUnit).startSpan();
    }

    public Span createSpan(String spanName, SpanKind spanKind, Context context, boolean isSpanFinishInOtherThread) throws TraceException {
        return this.tracer.spanBuilder(spanName).setParent(context).setSpanKind(spanKind).setStartTimestamp(System.currentTimeMillis(), TimeUnit.MILLISECONDS).startSpan();
    }

    public void shutdown() {
        this.sdkTracerProvider.close();
    }
}

