/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DuplicateMessageInfo<T> {
    public void checkDuplicatedMessageInfo(boolean bPrintLog, List<List<T>> lQueueList) throws IOException {
        int msgListSize = lQueueList.size();
        int maxmsgList = 0;
        HashMap<T, Integer> msgIdMap = new HashMap<T, Integer>();
        HashMap<Integer, Integer> dupMsgMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < msgListSize; ++i) {
            if (maxmsgList >= lQueueList.get(i).size()) continue;
            maxmsgList = lQueueList.get(i).size();
        }
        LinkedList<StringBuilder> strBQueue = new LinkedList<StringBuilder>();
        for (int i = 0; i < msgListSize; ++i) {
            strBQueue.add(new StringBuilder());
        }
        for (int msgListIndex = 0; msgListIndex < maxmsgList; ++msgListIndex) {
            for (int msgQueueListIndex = 0; msgQueueListIndex < msgListSize; ++msgQueueListIndex) {
                if (msgListIndex >= lQueueList.get(msgQueueListIndex).size()) continue;
                if (msgIdMap.containsKey(lQueueList.get(msgQueueListIndex).get(msgListIndex))) {
                    if (dupMsgMap.containsKey(msgQueueListIndex)) {
                        int dupMsgCount = (Integer)dupMsgMap.get(msgQueueListIndex);
                        dupMsgMap.remove(msgQueueListIndex);
                        dupMsgMap.put(msgQueueListIndex, ++dupMsgCount);
                    } else {
                        dupMsgMap.put(msgQueueListIndex, 1);
                    }
                    ((StringBuilder)strBQueue.get(msgQueueListIndex)).append("" + msgQueueListIndex + "\t" + msgIdMap.get(lQueueList.get(msgQueueListIndex).get(msgListIndex)) + "\t" + lQueueList.get(msgQueueListIndex).get(msgListIndex) + "\r\n");
                    continue;
                }
                msgIdMap.put(lQueueList.get(msgQueueListIndex).get(msgListIndex), msgQueueListIndex);
            }
        }
        int msgTotalNum = this.getMsgTotalNumber(lQueueList);
        int msgTotalDupNum = this.getDuplicateMsgNum(dupMsgMap);
        int msgNoDupNum = msgTotalNum - msgTotalDupNum;
        float msgDupRate = (float)msgTotalDupNum / (float)msgTotalNum * 100.0f;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("msgTotalNum:" + msgTotalNum + "\r\n");
        strBuilder.append("msgTotalDupNum:" + msgTotalDupNum + "\r\n");
        strBuilder.append("msgNoDupNum:" + msgNoDupNum + "\r\n");
        strBuilder.append("msgDupRate" + this.getFloatNumString(msgDupRate) + "%\r\n");
        strBuilder.append("queue\tmsg(dupNum/dupRate)\tdupRate\r\n");
        for (int i = 0; i < dupMsgMap.size(); ++i) {
            int msgDupNum = (Integer)dupMsgMap.get(i);
            int msgNum = lQueueList.get(i).size();
            float msgQueueDupRate = (float)msgDupNum / (float)msgTotalDupNum * 100.0f;
            float msgQueueInnerDupRate = (float)msgDupNum / (float)msgNum * 100.0f;
            strBuilder.append(i + "\t" + msgDupNum + "/" + this.getFloatNumString(msgQueueDupRate) + "%\t\t" + this.getFloatNumString(msgQueueInnerDupRate) + "%\r\n");
        }
        System.out.print(strBuilder.toString());
        String titleString = "queue\tdupQueue\tdupMsg\r\n";
        System.out.print(titleString);
        for (int i = 0; i < msgListSize; ++i) {
            System.out.print(((StringBuilder)strBQueue.get(i)).toString());
        }
        if (bPrintLog) {
            String logFileNameStr = "D:" + File.separator + "checkDuplicatedMessageInfo.txt";
            File logFileNameFile = new File(logFileNameStr);
            FileOutputStream out = new FileOutputStream(logFileNameFile, true);
            String strToWrite = strBuilder.toString() + titleString;
            for (int i = 0; i < msgListSize; ++i) {
                strToWrite = strToWrite + ((StringBuilder)strBQueue.get(i)).toString() + "\r\n";
            }
            byte[] byteToWrite = strToWrite.getBytes();
            ((OutputStream)out).write(byteToWrite);
            ((OutputStream)out).close();
        }
    }

    private int getMsgTotalNumber(List<List<T>> lQueueList) {
        int msgTotalNum = 0;
        for (int i = 0; i < lQueueList.size(); ++i) {
            msgTotalNum += lQueueList.get(i).size();
        }
        return msgTotalNum;
    }

    private int getDuplicateMsgNum(Map<Integer, Integer> msgDupMap) {
        int msgDupNum = 0;
        for (int i = 0; i < msgDupMap.size(); ++i) {
            msgDupNum += msgDupMap.get(i).intValue();
        }
        return msgDupNum;
    }

    private String getFloatNumString(float fNum) {
        DecimalFormat dcmFmt = new DecimalFormat("0.00");
        return dcmFmt.format(fNum);
    }
}

