/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.factory.MQMessageFactory;

public class MessageQueueMsg {
    private Map<MessageQueue, List<Object>> msgsWithMQ = null;
    private Map<Integer, List<Object>> msgsWithMQId = null;
    private Collection<Object> msgBodys = null;

    public MessageQueueMsg(List<MessageQueue> mqs, int msgSize) {
        this(mqs, msgSize, null);
    }

    public MessageQueueMsg(List<MessageQueue> mqs, int msgSize, String tag) {
        this.msgsWithMQ = MQMessageFactory.getMsgByMQ(mqs, msgSize, tag);
        this.msgsWithMQId = new HashMap<Integer, List<Object>>();
        this.msgBodys = new ArrayList<Object>();
        this.init();
    }

    public Map<MessageQueue, List<Object>> getMsgsWithMQ() {
        return this.msgsWithMQ;
    }

    public Map<Integer, List<Object>> getMsgWithMQId() {
        return this.msgsWithMQId;
    }

    public Collection<Object> getMsgBodys() {
        return this.msgBodys;
    }

    private void init() {
        for (Map.Entry<MessageQueue, List<Object>> mqEntry : this.msgsWithMQ.entrySet()) {
            this.msgsWithMQId.put(mqEntry.getKey().getQueueId(), mqEntry.getValue());
            this.msgBodys.addAll(MQMessageFactory.getMessageBody(mqEntry.getValue()));
        }
    }
}

