/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.admin.command;

import java.util.UUID;
import org.apache.eventmesh.connector.rocketmq.config.ClientConfiguration;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;

public abstract class Command {
    protected DefaultMQAdminExt adminExt;
    protected String nameServerAddr;
    protected String clusterName;

    public void init() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.init();
        this.nameServerAddr = clientConfiguration.namesrvAddr;
        this.clusterName = clientConfiguration.clusterName;
        String accessKey = clientConfiguration.accessKey;
        String secretKey = clientConfiguration.secretKey;
        AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
        this.adminExt = new DefaultMQAdminExt((RPCHook)rpcHook);
        String groupId = UUID.randomUUID().toString();
        this.adminExt.setAdminExtGroup("admin_ext_group-" + groupId);
        this.adminExt.setNamesrvAddr(this.nameServerAddr);
    }

    public abstract void execute() throws Exception;
}

