/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.standalone.broker.task;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.connector.standalone.broker.MessageQueue;
import org.apache.eventmesh.connector.standalone.broker.model.MessageEntity;
import org.apache.eventmesh.connector.standalone.broker.model.TopicMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryMessageClearTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(HistoryMessageClearTask.class);
    private final ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer;
    private static final long MESSAGE_STORE_WINDOW = 3600000L;

    public HistoryMessageClearTask(ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer) {
        this.messageContainer = messageContainer;
    }

    @Override
    public void run() {
        while (true) {
            this.messageContainer.forEach((topicMetadata, messageQueue) -> {
                long currentTimeMillis = System.currentTimeMillis();
                MessageEntity oldestMessage = messageQueue.getHead();
                if (oldestMessage == null) {
                    return;
                }
                if (currentTimeMillis - oldestMessage.getCreateTimeMills() >= 3600000L) {
                    messageQueue.removeHead();
                }
            });
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                continue;
            }
            catch (InterruptedException e) {
                this.logger.error("Thread is interrupted, thread name: {}", (Object)Thread.currentThread().getName(), (Object)e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }
}

