---
sidebar_position: 1
---

# Development Roadmap

The development roadmap of Apache EventMesh (Incubating) is an overview of the planned features and milestones involved in the next several releases. The recent features and bug fixes are documented in the [release notes](https://eventmesh.apache.org/events/release-notes/v1.4.0). The order of the features listed below doesn't correspond to their priorities.

## List of Features and Milestones

| Status | Description | Reference |
| --- | --- |  --- |
| **Implemented** | gRPC Integration | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/417) |
| **In Progress** | Event Governance for Choreography | [GitHub Issue](https://github.com/apache/incubator-eventmesh/blob/master/docs/en/features/eventmesh-workflow-design.md) |
| Planned | Knative Eventing Infrastructure | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/790), [GSoC '22](https://issues.apache.org/jira/browse/COMDEV-463) |
| Planned | Dashboard | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/700), [GSoC '22](https://issues.apache.org/jira/browse/COMDEV-465) |
| Planned | Event Streaming | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/676) |
| Planned | Federated Connector | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/577) |
| Planned | Transaction Event | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/697) |
| Planned | Event Query Language (EQL)| [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/778) |
| Planned | Metadata consistency persistent| [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/817)  |
| Planned | Go SDK | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/762) |
| Planned | Rust SDK | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/815) |
| Planned | WebAssembly Runtime| [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/576) |
| Planned | Filter Chain | [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/664) |
| Planned | Kafka-based EventStore| [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/199) |
| Planned | Redis-based EventStore| [GitHub Issue](https://github.com/apache/incubator-eventmesh/issues/389) |
