/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.api.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExporterConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ExporterConfiguration.class);
    private static final String CONFIG_FILE = "exporter.properties";
    private static final Properties properties = new Properties();
    private static int eventMeshTraceMaxExportSize = 512;
    private static int eventMeshTraceMaxQueueSize = 2048;
    private static int eventMeshTraceExportTimeout = 30;
    private static int eventMeshTraceExportInterval = 5;

    public static int getEventMeshTraceMaxExportSize() {
        return eventMeshTraceMaxExportSize;
    }

    public static int getEventMeshTraceMaxQueueSize() {
        return eventMeshTraceMaxQueueSize;
    }

    public static int getEventMeshTraceExportTimeout() {
        return eventMeshTraceExportTimeout;
    }

    public static int getEventMeshTraceExportInterval() {
        return eventMeshTraceExportInterval;
    }

    private static void initializeConfig() {
        String eventMeshTraceExportIntervalStr;
        String eventMeshTraceExportTimeoutStr;
        String eventMeshTraceMaxQueueSizeStr;
        String eventMeshTraceMaxExportSizeStr = properties.getProperty("eventmesh.trace.max.export.size");
        if (StringUtils.isNotEmpty((CharSequence)eventMeshTraceMaxExportSizeStr)) {
            eventMeshTraceMaxExportSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshTraceMaxExportSizeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTraceMaxQueueSizeStr = properties.getProperty("eventmesh.trace.max.queue.size")))) {
            eventMeshTraceMaxQueueSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshTraceMaxQueueSizeStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTraceExportTimeoutStr = properties.getProperty("eventmesh.trace.export.timeout")))) {
            eventMeshTraceExportTimeout = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshTraceExportTimeoutStr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventMeshTraceExportIntervalStr = properties.getProperty("eventmesh.trace.export.interval")))) {
            eventMeshTraceExportInterval = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshTraceExportIntervalStr));
        }
    }

    private static void loadProperties() {
        URL resource = ExporterConfiguration.class.getClassLoader().getResource(CONFIG_FILE);
        if (resource != null) {
            try (InputStream inputStream = resource.openStream();){
                if (inputStream.available() > 0) {
                    properties.load(new BufferedReader(new InputStreamReader(inputStream)));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Load exporter.properties file from classpath error");
            }
        }
        try {
            String configPath = System.getProperty("confPath", System.getenv("confPath")) + File.separator + CONFIG_FILE;
            if (new File(configPath).exists()) {
                properties.load(new BufferedReader(new FileReader(configPath)));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load exporter.properties file from conf");
        }
    }

    private ExporterConfiguration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ExporterConfiguration.loadProperties();
        ExporterConfiguration.initializeConfig();
    }
}

