/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage.resolver.grpc;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class GrpcMessageProtocolResolver {
    public static CloudEvent buildEvent(SimpleMessage message) throws ProtocolHandleException {
        try {
            RequestHeader requestHeader = message.getHeader();
            String protocolType = requestHeader.getProtocolType();
            String protocolDesc = requestHeader.getProtocolDesc();
            String protocolVersion = requestHeader.getProtocolVersion();
            String env = requestHeader.getEnv();
            String idc = requestHeader.getIdc();
            String ip = requestHeader.getIp();
            String pid = requestHeader.getPid();
            String sys = requestHeader.getSys();
            String username = requestHeader.getUsername();
            String passwd = requestHeader.getPassword();
            String language = requestHeader.getLanguage();
            String content = message.getContent();
            CloudEvent event = null;
            if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
                io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v1();
                cloudEventBuilder = cloudEventBuilder.withId(message.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", message.getSeqNum()).withExtension("uniqueid", message.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", message.getTtl());
                for (Map.Entry entry : message.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)message.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", message.getTag());
                }
                event = cloudEventBuilder.build();
            } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
                CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v03();
                cloudEventBuilder = cloudEventBuilder.withId(message.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", message.getSeqNum()).withExtension("uniqueid", message.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", message.getTtl());
                for (Map.Entry entry : message.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)message.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", message.getTag());
                }
                event = cloudEventBuilder.build();
            }
            return event;
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), e.getCause());
        }
    }

    public static List<CloudEvent> buildBatchEvents(BatchMessage message) {
        LinkedList<CloudEvent> events = new LinkedList<CloudEvent>();
        RequestHeader requestHeader = message.getHeader();
        String protocolType = requestHeader.getProtocolType();
        String protocolDesc = requestHeader.getProtocolDesc();
        String protocolVersion = requestHeader.getProtocolVersion();
        String env = requestHeader.getEnv();
        String idc = requestHeader.getIdc();
        String ip = requestHeader.getIp();
        String pid = requestHeader.getPid();
        String sys = requestHeader.getSys();
        String username = requestHeader.getUsername();
        String passwd = requestHeader.getPassword();
        String language = requestHeader.getLanguage();
        for (BatchMessage.MessageItem item : message.getMessageItemList()) {
            io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder;
            String content = item.getContent();
            CloudEvent event = null;
            if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
                cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v1();
                cloudEventBuilder = cloudEventBuilder.withId(item.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", item.getSeqNum()).withExtension("uniqueid", item.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", item.getTtl());
                for (Map.Entry entry : item.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", item.getTag());
                }
                event = cloudEventBuilder.build();
            } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
                cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v03();
                cloudEventBuilder = cloudEventBuilder.withId(item.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", item.getSeqNum()).withExtension("uniqueid", item.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", item.getTtl());
                for (Map.Entry entry : item.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", item.getTag());
                }
                event = cloudEventBuilder.build();
            }
            events.add(event);
        }
        return events;
    }

    public static SimpleMessageWrapper buildSimpleMessage(CloudEvent cloudEvent) {
        String env = cloudEvent.getExtension("env") == null ? "env" : cloudEvent.getExtension("env").toString();
        String idc = cloudEvent.getExtension("idc") == null ? "idc" : cloudEvent.getExtension("idc").toString();
        String ip = cloudEvent.getExtension("ip") == null ? "ip" : cloudEvent.getExtension("ip").toString();
        String pid = cloudEvent.getExtension("pid") == null ? "33" : cloudEvent.getExtension("pid").toString();
        String sys = cloudEvent.getExtension("sys") == null ? "sys" : cloudEvent.getExtension("sys").toString();
        String userName = cloudEvent.getExtension("username") == null ? "user" : cloudEvent.getExtension("username").toString();
        String passwd = cloudEvent.getExtension("passwd") == null ? "pass" : cloudEvent.getExtension("passwd").toString();
        String language = cloudEvent.getExtension("language") == null ? "JAVA" : cloudEvent.getExtension("language").toString();
        String protocol = cloudEvent.getExtension("protocoltype") == null ? "" : cloudEvent.getExtension("protocoltype").toString();
        String protocolDesc = cloudEvent.getExtension("protocoldesc") == null ? "" : cloudEvent.getExtension("protocoldesc").toString();
        String protocolVersion = cloudEvent.getExtension("protocolversion") == null ? "" : cloudEvent.getExtension("protocolversion").toString();
        String seqNum = cloudEvent.getExtension("seqnum") == null ? "" : cloudEvent.getExtension("seqnum").toString();
        String uniqueId = cloudEvent.getExtension("uniqueid") == null ? "" : cloudEvent.getExtension("uniqueid").toString();
        String producerGroup = cloudEvent.getExtension("producergroup") == null ? "" : cloudEvent.getExtension("producergroup").toString();
        String ttl = cloudEvent.getExtension("ttl") == null ? "4000" : cloudEvent.getExtension("ttl").toString();
        RequestHeader header = RequestHeader.newBuilder().setEnv(env).setIdc(idc).setIp(ip).setPid(pid).setSys(sys).setUsername(userName).setPassword(passwd).setLanguage(language).setProtocolType(protocol).setProtocolDesc(protocolDesc).setProtocolVersion(protocolVersion).build();
        SimpleMessage.Builder messageBuilder = SimpleMessage.newBuilder().setHeader(header).setContent(new String(cloudEvent.getData().toBytes(), StandardCharsets.UTF_8)).setProducerGroup(producerGroup).setSeqNum(seqNum).setUniqueId(uniqueId).setTopic(cloudEvent.getSubject()).setTtl(ttl);
        for (String key : cloudEvent.getExtensionNames()) {
            messageBuilder.putProperties(key, cloudEvent.getExtension(key).toString());
        }
        SimpleMessage simpleMessage = messageBuilder.build();
        return new SimpleMessageWrapper(simpleMessage);
    }
}

