/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.body.message;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.utils.JsonUtils;

public class SendMessageBatchRequestBody
extends Body {
    public static final String BATCHID = "batchId";
    public static final String CONTENTS = "contents";
    public static final String SIZE = "size";
    public static final String PRODUCERGROUP = "producerGroup";
    private String batchId;
    private List<BatchMessageEntity> contents;
    private String size;
    private String producerGroup;

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public List<BatchMessageEntity> getContents() {
        return this.contents;
    }

    public void setContents(List<BatchMessageEntity> contents) {
        this.contents = contents;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sendMessageBatchRequestBody={").append("batchId=").append(this.batchId).append(",").append("size=").append(this.size).append(",").append("producerGroup=").append(this.producerGroup).append(",").append("contents=").append(JsonUtils.serialize(this.contents)).append("}");
        return sb.toString();
    }

    public static SendMessageBatchRequestBody buildBody(Map<String, Object> bodyParam) {
        String batchId = MapUtils.getString(bodyParam, (Object)BATCHID);
        String size = StringUtils.isBlank((CharSequence)MapUtils.getString(bodyParam, (Object)SIZE)) ? "1" : MapUtils.getString(bodyParam, (Object)SIZE);
        String contents = MapUtils.getString(bodyParam, (Object)CONTENTS, null);
        SendMessageBatchRequestBody body = new SendMessageBatchRequestBody();
        body.setBatchId(batchId);
        if (StringUtils.isNotBlank((CharSequence)contents)) {
            body.setContents(JsonUtils.deserialize(contents, new TypeReference<List<BatchMessageEntity>>(){}));
        }
        body.setSize(size);
        body.setProducerGroup(MapUtils.getString(bodyParam, (Object)PRODUCERGROUP));
        return body;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(BATCHID, this.batchId);
        map.put(SIZE, this.size);
        map.put(CONTENTS, this.contents);
        map.put(PRODUCERGROUP, this.producerGroup);
        return map;
    }

    public static class BatchMessageEntity {
        public String bizSeqNo;
        public String topic;
        public String msg;
        public String tag;
        public String ttl;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("batchMessageEntity={").append("bizSeqNo=").append(this.bizSeqNo).append(",").append("topic=").append(this.topic).append(",").append("msg=").append(this.msg).append(",").append("ttl=").append(this.ttl).append(",").append("tag=").append(this.tag).append("}");
            return sb.toString();
        }
    }
}

