/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendStatus;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.UpStreamMsgContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.trace.AttributeKeys;
import org.apache.eventmesh.runtime.trace.SpanKey;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTransferTask
extends AbstractTask {
    private final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    private static final int TRY_PERMIT_TIME_OUT = 5;

    public MessageTransferTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            final long taskExecuteTime = System.currentTimeMillis();
            Command cmd = this.pkg.getHeader().getCmd();
            try {
                if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerTraceEnable && !Command.RESPONSE_TO_SERVER.equals((Object)cmd)) {
                    Span span = TraceUtils.prepareServerSpan(this.pkg.getHeader().getProperties(), "upstream-eventmesh-server-span", this.startTime, TimeUnit.MILLISECONDS, true);
                    Context context = Context.current().with(SpanKey.SERVER_KEY, (Object)span);
                    this.ctx.channel().attr(AttributeKeys.SERVER_CONTEXT).set((Object)context);
                }
            }
            catch (Throwable ex) {
                this.logger.warn("upload trace fail in MessageTransferTask[server-span-start]", ex);
            }
            Command replyCmd = this.getReplyCmd(cmd);
            final Package msg = new Package();
            boolean retCode = false;
            CloudEvent event = null;
            try {
                ProtocolAdaptor protocolAdaptor;
                String protocolType = "EventMeshMessage";
                if (this.pkg.getHeader().getProperties() != null && this.pkg.getHeader().getProperty("protocoltype") != null) {
                    protocolType = (String)this.pkg.getHeader().getProperty("protocoltype");
                }
                if ((event = (protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType)).toCloudEvent((ProtocolTransportObject)this.pkg)) == null) {
                    throw new Exception("event is null");
                }
                String content = new String(event.getData().toBytes(), StandardCharsets.UTF_8);
                if (content.length() > this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshEventSize) {
                    throw new Exception("event size exceeds the limit: " + this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshEventSize);
                }
                if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerSecurityEnable) {
                    String remoteAddr = RemotingHelper.parseChannelRemoteAddr(this.ctx.channel());
                    Acl.doAclCheckInTcpSend(remoteAddr, this.session.getClient(), event.getSubject(), cmd.value());
                }
                if (!this.eventMeshTCPServer.getRateLimiter().tryAcquire(5L, TimeUnit.MILLISECONDS)) {
                    msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), "Tps overload, global flow control", this.pkg.getHeader().getSeq()));
                    this.ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            Utils.logSucceedMessageFlow(msg, MessageTransferTask.this.session.getClient(), MessageTransferTask.this.startTime, taskExecuteTime);
                        }
                    });
                    TraceUtils.finishSpanWithException(this.ctx, event, "Tps overload, global flow control", null);
                    this.logger.warn("======Tps overload, global flow control, rate:{}! PLEASE CHECK!========", (Object)this.eventMeshTCPServer.getRateLimiter().getRate());
                    return;
                }
                Session session = this.session;
                synchronized (session) {
                    long sendTime = System.currentTimeMillis();
                    event = this.addTimestamp(event, cmd, sendTime);
                    EventMeshTcpSendResult sendStatus = this.session.upstreamMsg(this.pkg.getHeader(), event, this.createSendCallback(replyCmd, taskExecuteTime, event), this.startTime, taskExecuteTime);
                    if (!StringUtils.equals((CharSequence)EventMeshTcpSendStatus.SUCCESS.name(), (CharSequence)sendStatus.getSendStatus().name())) {
                        throw new Exception(sendStatus.getDetail());
                    }
                    this.messageLogger.info("pkg|eventMesh2mq|cmd={}|Msg={}|user={}|wait={}ms|cost={}ms", new Object[]{cmd, event, this.session.getClient(), taskExecuteTime - this.startTime, sendTime - this.startTime});
                }
            }
            catch (Exception e) {
                this.logger.error("MessageTransferTask failed|cmd={}|event={}|user={}", new Object[]{cmd, event, this.session.getClient(), e});
                if (cmd.equals((Object)Command.RESPONSE_TO_SERVER)) break block14;
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), e.toString(), this.pkg.getHeader().getSeq()));
                Utils.writeAndFlush(msg, this.startTime, taskExecuteTime, this.session.getContext(), this.session);
                TraceUtils.finishSpanWithException(this.ctx, event, "MessageTransferTask failed", (Throwable)e);
            }
        }
    }

    private CloudEvent addTimestamp(CloudEvent event, Command cmd, long sendTime) {
        event = cmd.equals((Object)Command.RESPONSE_TO_SERVER) ? CloudEventBuilder.from((CloudEvent)event).withExtension("rspc2eventmeshtimestamp", String.valueOf(this.startTime)).withExtension("rspeventmesh2mqtimestamp", String.valueOf(sendTime)).withExtension("rspsendeventmeship", this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerIp).build() : CloudEventBuilder.from((CloudEvent)event).withExtension("reqc2eventmeshtimestamp", String.valueOf(this.startTime)).withExtension("reqeventmesh2mqtimestamp", String.valueOf(sendTime)).withExtension("reqsendeventmeship", this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerIp).build();
        return event;
    }

    private Command getReplyCmd(Command cmd) {
        switch (cmd) {
            case REQUEST_TO_SERVER: {
                return Command.RESPONSE_TO_CLIENT;
            }
            case ASYNC_MESSAGE_TO_SERVER: {
                return Command.ASYNC_MESSAGE_TO_SERVER_ACK;
            }
            case BROADCAST_MESSAGE_TO_SERVER: {
                return Command.BROADCAST_MESSAGE_TO_SERVER_ACK;
            }
        }
        return cmd;
    }

    protected SendCallback createSendCallback(final Command replyCmd, final long taskExecuteTime, final CloudEvent event) {
        final long createTime = System.currentTimeMillis();
        final Package msg = new Package();
        return new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                MessageTransferTask.this.session.getSender().getUpstreamBuff().release();
                MessageTransferTask.this.messageLogger.info("upstreamMsg message success|user={}|callback cost={}", (Object)MessageTransferTask.this.session.getClient(), (Object)(System.currentTimeMillis() - createTime));
                if (replyCmd.equals((Object)Command.BROADCAST_MESSAGE_TO_SERVER_ACK) || replyCmd.equals((Object)Command.ASYNC_MESSAGE_TO_SERVER_ACK)) {
                    msg.setHeader(new Header(replyCmd, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), MessageTransferTask.this.pkg.getHeader().getSeq()));
                    msg.setBody((Object)event);
                    Utils.writeAndFlush(msg, MessageTransferTask.this.startTime, taskExecuteTime, MessageTransferTask.this.session.getContext(), MessageTransferTask.this.session);
                    TraceUtils.finishSpan(MessageTransferTask.this.ctx, event);
                }
            }

            public void onException(OnExceptionContext context) {
                MessageTransferTask.this.session.getSender().getUpstreamBuff().release();
                UpStreamMsgContext upStreamMsgContext = new UpStreamMsgContext(MessageTransferTask.this.session, event, MessageTransferTask.this.pkg.getHeader(), MessageTransferTask.this.startTime, taskExecuteTime);
                upStreamMsgContext.delay(10000L);
                ((ClientGroupWrapper)MessageTransferTask.this.session.getClientGroupWrapper().get()).getEventMeshTcpRetryer().pushRetry(upStreamMsgContext);
                MessageTransferTask.this.session.getSender().failMsgCount.incrementAndGet();
                MessageTransferTask.this.messageLogger.error("upstreamMsg mq message error|user={}|callback cost={}, errMsg={}", new Object[]{MessageTransferTask.this.session.getClient(), System.currentTimeMillis() - createTime, new Exception((Throwable)context.getException())});
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), context.getException().toString(), MessageTransferTask.this.pkg.getHeader().getSeq()));
                msg.setBody((Object)event);
                Utils.writeAndFlush(msg, MessageTransferTask.this.startTime, taskExecuteTime, MessageTransferTask.this.session.getContext(), MessageTransferTask.this.session);
                if (!replyCmd.equals((Object)Command.RESPONSE_TO_SERVER)) {
                    TraceUtils.finishSpanWithException(MessageTransferTask.this.ctx, event, "upload trace fail in MessageTransferTask.createSendCallback.onException", (Throwable)context.getException());
                }
            }
        };
    }
}

