/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send;

import io.cloudevents.CloudEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry.RetryContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendStatus;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpStreamMsgContext
extends RetryContext {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Session session;
    private long createTime = System.currentTimeMillis();
    private Header header;
    private long startTime;
    private long taskExecuteTime;

    public UpStreamMsgContext(Session session, CloudEvent event, Header header, long startTime, long taskExecuteTime) {
        this.seq = header.getSeq();
        this.session = session;
        this.event = event;
        this.header = header;
        this.startTime = startTime;
        this.taskExecuteTime = taskExecuteTime;
    }

    public Session getSession() {
        return this.session;
    }

    public CloudEvent getEvent() {
        return this.event;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        return "UpStreamMsgContext{seq=" + this.seq + ",topic=" + this.event.getSubject() + ",client=" + this.session.getClient() + ",retryTimes=" + this.retryTimes + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + "},executeTime=" + DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS");
    }

    @Override
    public void retry() {
        this.logger.info("retry upStream msg start,seq:{},retryTimes:{},bizSeq:{}", new Object[]{this.seq, this.retryTimes, EventMeshUtil.getMessageBizSeq(this.event)});
        try {
            Command replyCmd = this.getReplyCmd(this.header.getCmd());
            long sendTime = System.currentTimeMillis();
            EventMeshTcpSendResult sendStatus = this.session.upstreamMsg(this.header, this.event, this.createSendCallback(replyCmd, this.taskExecuteTime, this.event), this.startTime, this.taskExecuteTime);
            if (!StringUtils.equals((CharSequence)EventMeshTcpSendStatus.SUCCESS.name(), (CharSequence)sendStatus.getSendStatus().name())) {
                throw new Exception(sendStatus.getDetail());
            }
            this.logger.info("pkg|eventMesh2mq|cmd={}|event={}|user={}|wait={}ms|cost={}ms", new Object[]{this.header.getCmd(), this.event, this.session.getClient(), this.taskExecuteTime - this.startTime, sendTime - this.startTime});
        }
        catch (Exception e) {
            this.logger.error("TCP UpstreamMsg Retry error", (Throwable)e);
        }
    }

    protected SendCallback createSendCallback(final Command replyCmd, final long taskExecuteTime, final CloudEvent event) {
        final long createTime = System.currentTimeMillis();
        final Package msg = new Package();
        return new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                UpStreamMsgContext.this.session.getSender().getUpstreamBuff().release();
                UpStreamMsgContext.this.logger.info("upstreamMsg message success|user={}|callback cost={}", (Object)UpStreamMsgContext.this.session.getClient(), (Object)(System.currentTimeMillis() - createTime));
                if (replyCmd.equals((Object)Command.BROADCAST_MESSAGE_TO_SERVER_ACK) || replyCmd.equals((Object)Command.ASYNC_MESSAGE_TO_SERVER_ACK)) {
                    msg.setHeader(new Header(replyCmd, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), UpStreamMsgContext.this.seq));
                    msg.setBody((Object)event);
                    Utils.writeAndFlush(msg, UpStreamMsgContext.this.startTime, taskExecuteTime, UpStreamMsgContext.this.session.getContext(), UpStreamMsgContext.this.session);
                }
            }

            public void onException(OnExceptionContext context) {
                UpStreamMsgContext.this.session.getSender().getUpstreamBuff().release();
                UpStreamMsgContext upStreamMsgContext = new UpStreamMsgContext(UpStreamMsgContext.this.session, event, UpStreamMsgContext.this.header, UpStreamMsgContext.this.startTime, taskExecuteTime);
                upStreamMsgContext.delay(10000L);
                ((ClientGroupWrapper)UpStreamMsgContext.this.session.getClientGroupWrapper().get()).getEventMeshTcpRetryer().pushRetry(upStreamMsgContext);
                ((UpStreamMsgContext)UpStreamMsgContext.this).session.getSender().failMsgCount.incrementAndGet();
                UpStreamMsgContext.this.logger.error("upstreamMsg mq message error|user={}|callback cost={}, errMsg={}", new Object[]{UpStreamMsgContext.this.session.getClient(), System.currentTimeMillis() - createTime, new Exception((Throwable)context.getException())});
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), context.getException().toString(), UpStreamMsgContext.this.seq));
                msg.setBody((Object)event);
                Utils.writeAndFlush(msg, UpStreamMsgContext.this.startTime, taskExecuteTime, UpStreamMsgContext.this.session.getContext(), UpStreamMsgContext.this.session);
            }
        };
    }

    private Command getReplyCmd(Command cmd) {
        switch (cmd) {
            case REQUEST_TO_SERVER: {
                return Command.RESPONSE_TO_CLIENT;
            }
            case ASYNC_MESSAGE_TO_SERVER: {
                return Command.ASYNC_MESSAGE_TO_SERVER_ACK;
            }
            case BROADCAST_MESSAGE_TO_SERVER: {
                return Command.BROADCAST_MESSAGE_TO_SERVER_ACK;
            }
        }
        return cmd;
    }
}

