/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.EventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAsyncEventProcessor
implements EventProcessor {
    public Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private EventMeshHTTPServer eventMeshHTTPServer;

    public SendAsyncEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, final AsyncContext<HttpEventWrapper> asyncContext) throws Exception {
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        this.cmdLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        Map requestHeaderMap = requestWrapper.getHeaderMap();
        String source = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        requestHeaderMap.put("ip", source);
        requestWrapper.buildSysHeaderForClient();
        requestHeaderMap.putIfAbsent("source", source);
        requestWrapper.buildSysHeaderForCE();
        final String bizNo = requestHeaderMap.getOrDefault("bizseqno", RandomStringUtils.generateNum((int)30)).toString();
        final String uniqueId = requestHeaderMap.getOrDefault("uniqueid", RandomStringUtils.generateNum((int)30)).toString();
        String ttl = ((Object)requestHeaderMap.getOrDefault("ttl", 4000)).toString();
        requestWrapper.getSysHeaderMap().putIfAbsent("bizseqno", bizNo);
        requestWrapper.getSysHeaderMap().putIfAbsent("uniqueid", uniqueId);
        requestWrapper.getSysHeaderMap().putIfAbsent("ttl", ttl);
        final HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster);
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv);
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        final HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        String protocolType = requestHeaderMap.getOrDefault("protocoltype", "http").toString();
        ProtocolAdaptor httpProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpProtocolAdaptor.toCloudEvent((ProtocolTransportObject)requestWrapper);
        if (event == null || StringUtils.isBlank((CharSequence)event.getId()) || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isBlank((CharSequence)event.getType()) || StringUtils.isBlank((CharSequence)event.getSubject())) {
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        String idc = event.getExtension("idc").toString();
        String pid = event.getExtension("pid").toString();
        String sys = event.getExtension("sys").toString();
        if (StringUtils.isBlank((CharSequence)idc) || StringUtils.isBlank((CharSequence)pid) || !StringUtils.isNumeric((CharSequence)pid) || StringUtils.isBlank((CharSequence)sys)) {
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        String producerGroup = event.getExtension("producergroup").toString();
        final String topic = event.getSubject();
        if (StringUtils.isBlank((CharSequence)bizNo) || StringUtils.isBlank((CharSequence)uniqueId) || StringUtils.isBlank((CharSequence)producerGroup) || StringUtils.isBlank((CharSequence)topic) || event.getData() == null) {
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerSecurityEnable) {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String user = event.getExtension("username").toString();
            String pass = event.getExtension("passwd").toString();
            String subsystem = event.getExtension("sys").toString();
            String requestURI = requestWrapper.getRequestURI();
            try {
                Acl.doAclCheckInHttpSend(remoteAddr, user, pass, subsystem, topic, requestURI);
            }
            catch (Exception e) {
                responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_ACL_ERR.getErrMsg());
                HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
                asyncContext.onComplete(responseWrapper);
                this.aclLogger.warn("CLIENT HAS NO PERMISSION,SendAsyncMessageProcessor send failed", (Throwable)e);
                return;
            }
        }
        if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPDiscard();
            asyncContext.onComplete(responseWrapper);
            return;
        }
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.getStarted().get()) {
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        String content = new String(event.getData().toBytes(), StandardCharsets.UTF_8);
        if (content.length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize) {
            this.httpLogger.error("Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap.put("retMsg", "Event size exceeds the limit: " + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            if (this.messageLogger.isDebugEnabled()) {
                this.messageLogger.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)topic);
            }
        }
        catch (Exception e) {
            this.messageLogger.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{bizNo, topic, e});
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2));
            HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, eventMeshProducer, this.eventMeshHTTPServer);
        this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsg();
        final long startTime = System.currentTimeMillis();
        final CompleteHandler<HttpEventWrapper> handler = httpEventWrapper -> {
            try {
                if (this.httpLogger.isDebugEnabled()) {
                    this.httpLogger.debug("{}", httpEventWrapper);
                }
                this.eventMeshHTTPServer.sendResponse(ctx, httpEventWrapper.httpResponse());
                this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpEventWrapper)asyncContext.getRequest()).getReqTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        try {
            event = CloudEventBuilder.from((CloudEvent)sendMessageContext.getEvent()).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            sendMessageContext.setEvent(event);
            eventMeshProducer.send(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                    responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg() + sendResult.toString());
                    HttpEventWrapper succ = ((HttpEventWrapper)asyncContext.getRequest()).createHttpResponse(responseHeaderMap, responseBodyMap);
                    asyncContext.onComplete(succ, handler);
                    long endTime = System.currentTimeMillis();
                    ((SendAsyncEventProcessor)SendAsyncEventProcessor.this).eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                    SendAsyncEventProcessor.this.messageLogger.info("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId});
                }

                public void onException(OnExceptionContext context) {
                    responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode());
                    responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2));
                    HttpEventWrapper err = ((HttpEventWrapper)asyncContext.getRequest()).createHttpResponse(responseHeaderMap, responseBodyMap);
                    asyncContext.onComplete(err, handler);
                    SendAsyncEventProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    long endTime = System.currentTimeMillis();
                    ((SendAsyncEventProcessor)SendAsyncEventProcessor.this).eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
                    ((SendAsyncEventProcessor)SendAsyncEventProcessor.this).eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                    SendAsyncEventProcessor.this.messageLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId, context.getException()});
                }
            });
        }
        catch (Exception ex) {
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2));
            HttpEventWrapper err = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(err);
            this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
            long endTime = System.currentTimeMillis();
            this.messageLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, bizNo, uniqueId, ex});
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

