/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUnSubscribeEventProcessor
extends AbstractEventProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");

    public RemoteUnSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpEventWrapper> asyncContext) throws Exception {
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        this.httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        String requestIp = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        userRequestHeaderMap.put("ip", requestIp);
        requestWrapper.buildSysHeaderForClient();
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster);
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv);
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        if (StringUtils.isBlank((CharSequence)sysHeaderMap.get("idc").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("pid").toString()) || !StringUtils.isNumeric((CharSequence)sysHeaderMap.get("pid").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("sys").toString())) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = (Map)JsonUtils.deserialize((String)new String(requestBody), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (requestBodyMap.get("url") == null || requestBodyMap.get("topic") == null || requestBodyMap.get("consumerGroup") == null) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        String unSubscribeUrl = requestBodyMap.get("url").toString();
        String consumerGroup = requestBodyMap.get("consumerGroup").toString();
        String topic = requestBodyMap.get("topic").toString();
        long startTime = System.currentTimeMillis();
        try {
            String env = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv;
            String idc = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC;
            String cluster = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster;
            String sysId = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().sysID;
            String meshGroup = env + "-" + idc + "-" + cluster + "-" + sysId;
            HashMap<String, String> remoteHeaderMap = new HashMap<String, String>();
            remoteHeaderMap.put("env", env);
            remoteHeaderMap.put("idc", idc);
            remoteHeaderMap.put("ip", IPUtils.getLocalAddress());
            remoteHeaderMap.put("pid", String.valueOf(ThreadUtils.getPID()));
            remoteHeaderMap.put("sys", sysId);
            remoteHeaderMap.put("username", "eventmesh");
            remoteHeaderMap.put("passwd", "pass");
            remoteHeaderMap.put("producergroup", meshGroup);
            remoteHeaderMap.put("consumergroup", meshGroup);
            String unsubscribeUrl = "http://" + IPUtils.getLocalAddress() + ":" + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().httpServerPort + RequestURI.PUBLISH_BRIDGE.getRequestURI();
            HashMap<String, Object> remoteBodyMap = new HashMap<String, Object>();
            remoteBodyMap.put("url", unsubscribeUrl);
            remoteBodyMap.put("consumerGroup", meshGroup);
            remoteBodyMap.put("topic", requestBodyMap.get("topic"));
            List unSubTopicList = (List)JsonUtils.deserialize((String)topic, (TypeReference)new TypeReference<List<String>>(){});
            String targetMesh = requestBodyMap.get("remoteMesh").toString();
            List<SubscriptionItem> subscriptionList = unSubTopicList.stream().map(s -> {
                SubscriptionItem subscriptionItem = new SubscriptionItem();
                subscriptionItem.setTopic(s);
                return subscriptionItem;
            }).collect(Collectors.toList());
            String meshAddress = this.getTargetMesh(consumerGroup, subscriptionList);
            if (StringUtils.isNotBlank((CharSequence)meshAddress)) {
                targetMesh = meshAddress;
            }
            CloseableHttpClient closeableHttpClient = this.eventMeshHTTPServer.httpClientPool.getClient();
            String remoteResult = RemoteUnSubscribeEventProcessor.post(closeableHttpClient, targetMesh, remoteHeaderMap, remoteBodyMap, (ResponseHandler<String>)((ResponseHandler)response -> EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"))));
            Map remoteResultMap = (Map)JsonUtils.deserialize((String)remoteResult, (TypeReference)new TypeReference<Map<String, String>>(){});
            CompleteHandler<HttpEventWrapper> handler = httpEventWrapper -> {
                try {
                    if (this.httpLogger.isDebugEnabled()) {
                        this.httpLogger.debug("{}", httpEventWrapper);
                    }
                    this.eventMeshHTTPServer.sendResponse(ctx, httpEventWrapper.httpResponse());
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            if (String.valueOf(EventMeshRetCode.SUCCESS.getRetCode()).equals(remoteResultMap.get("retCode"))) {
                HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(EventMeshRetCode.SUCCESS);
                asyncContext.onComplete(responseWrapper, handler);
            } else {
                HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
                responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg());
                HttpEventWrapper err = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
                asyncContext.onComplete(err);
            }
        }
        catch (Exception e) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2));
            HttpEventWrapper err = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(err);
            long endTime = System.currentTimeMillis();
            this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, unSubscribeUrl, e});
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    public static String post(CloseableHttpClient client, String uri, Map<String, String> requestHeader, Map<String, Object> requestBody, ResponseHandler<String> responseHandler) throws IOException {
        Preconditions.checkState((client != null ? 1 : 0) != 0, (Object)"client can't be null");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"uri can't be null");
        Preconditions.checkState((requestHeader != null ? 1 : 0) != 0, (Object)"requestParam can't be null");
        Preconditions.checkState((responseHandler != null ? 1 : 0) != 0, (Object)"responseHandler can't be null");
        HttpPost httpPost = new HttpPost(uri);
        httpPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        if (MapUtils.isNotEmpty(requestHeader)) {
            for (Map.Entry<String, String> entry : requestHeader.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(requestBody)) {
            String jsonStr = JsonUtils.serialize(requestBody);
            httpPost.setEntity((HttpEntity)new StringEntity(jsonStr, ContentType.APPLICATION_JSON));
        }
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setSocketTimeout(Integer.parseInt(String.valueOf(15000))).setConnectTimeout(Integer.parseInt(String.valueOf(15000))).setConnectionRequestTimeout(Integer.parseInt(String.valueOf(15000)));
        httpPost.setConfig(configBuilder.build());
        return (String)client.execute((HttpUriRequest)httpPost, responseHandler);
    }
}

