/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalUnSubscribeEventProcessor
extends AbstractEventProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");

    public LocalUnSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpEventWrapper> asyncContext) throws Exception {
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        this.httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        String requestIp = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        userRequestHeaderMap.put("ip", requestIp);
        requestWrapper.buildSysHeaderForClient();
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster);
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv);
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        if (StringUtils.isBlank((CharSequence)sysHeaderMap.get("idc").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("pid").toString()) || !StringUtils.isNumeric((CharSequence)sysHeaderMap.get("pid").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("sys").toString())) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = (Map)JsonUtils.deserialize((String)new String(requestBody), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (requestBodyMap.get("url") == null || requestBodyMap.get("topic") == null || requestBodyMap.get("consumerGroup") == null) {
            HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        String unSubscribeUrl = requestBodyMap.get("url").toString();
        String consumerGroup = requestBodyMap.get("consumerGroup").toString();
        String topic = JsonUtils.serialize(requestBodyMap.get("topic"));
        List unSubTopicList = (List)JsonUtils.deserialize((String)topic, (TypeReference)new TypeReference<List<String>>(){});
        String env = sysHeaderMap.get("env").toString();
        String idc = sysHeaderMap.get("idc").toString();
        String sys = sysHeaderMap.get("sys").toString();
        String ip = sysHeaderMap.get("ip").toString();
        String pid = sysHeaderMap.get("pid").toString();
        CompleteHandler<HttpEventWrapper> handler = httpEventWrapper -> {
            try {
                if (this.httpLogger.isDebugEnabled()) {
                    this.httpLogger.debug("{}", httpEventWrapper);
                }
                this.eventMeshHTTPServer.sendResponse(ctx, httpEventWrapper.httpResponse());
                this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpEventWrapper)asyncContext.getRequest()).getReqTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.localClientInfoMapping;
        synchronized (concurrentHashMap) {
            HttpEventWrapper err;
            HashMap<String, Object> responseBodyMap;
            boolean isChange = true;
            this.registerClient(requestWrapper, consumerGroup, unSubTopicList, unSubscribeUrl);
            for (String unSubTopic : unSubTopicList) {
                List<Client> groupTopicClients = this.eventMeshHTTPServer.localClientInfoMapping.get(consumerGroup + "@" + unSubTopic);
                Iterator<Client> clientIterator = groupTopicClients.iterator();
                while (clientIterator.hasNext()) {
                    Client client = clientIterator.next();
                    if (!StringUtils.equals((CharSequence)client.pid, (CharSequence)pid) || !StringUtils.equals((CharSequence)client.url, (CharSequence)unSubscribeUrl)) continue;
                    this.httpLogger.warn("client {} start unsubscribe", (Object)JsonUtils.serialize((Object)client));
                    clientIterator.remove();
                }
                if (groupTopicClients.size() > 0) {
                    HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                    HashSet<String> clientUrls = new HashSet<String>();
                    for (Client client : groupTopicClients) {
                        if (StringUtils.equals((CharSequence)unSubscribeUrl, (CharSequence)client.url)) continue;
                        clientUrls.add(client.url);
                        if (idcUrls.containsKey(client.idc)) {
                            ((List)idcUrls.get(client.idc)).add(StringUtils.deleteWhitespace((String)client.url));
                            continue;
                        }
                        ArrayList<String> urls = new ArrayList<String>();
                        urls.add(client.url);
                        idcUrls.put(client.idc, urls);
                    }
                    ConcurrentHashMap<String, ConsumerGroupConf> concurrentHashMap2 = this.eventMeshHTTPServer.localConsumerGroupMapping;
                    synchronized (concurrentHashMap2) {
                        ConsumerGroupConf consumerGroupConf = this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup);
                        Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                        for (String topicKey : map.keySet()) {
                            if (!StringUtils.equals((CharSequence)unSubTopic, (CharSequence)topicKey)) continue;
                            ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                            latestTopicConf.setConsumerGroup(consumerGroup);
                            latestTopicConf.setTopic(unSubTopic);
                            latestTopicConf.setSubscriptionItem(map.get(topicKey).getSubscriptionItem());
                            latestTopicConf.setUrls(clientUrls);
                            latestTopicConf.setIdcUrls(idcUrls);
                            map.put(unSubTopic, latestTopicConf);
                        }
                        this.eventMeshHTTPServer.localConsumerGroupMapping.put(consumerGroup, consumerGroupConf);
                        continue;
                    }
                }
                isChange = false;
                break;
            }
            long startTime = System.currentTimeMillis();
            if (isChange) {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup));
                    HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseWrapper, handler);
                }
                catch (Exception e) {
                    responseBodyMap = new HashMap<String, Object>();
                    responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode());
                    responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2));
                    err = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
                    asyncContext.onComplete(err);
                    long endTime = System.currentTimeMillis();
                    this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)unSubTopicList), unSubscribeUrl, e});
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                }
            } else {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, null);
                    HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseWrapper, handler);
                    this.eventMeshHTTPServer.localClientInfoMapping.keySet().removeIf(s -> StringUtils.contains((CharSequence)s, (CharSequence)consumerGroup));
                    this.eventMeshHTTPServer.localConsumerGroupMapping.keySet().removeIf(s -> StringUtils.equals((CharSequence)consumerGroup, (CharSequence)s));
                }
                catch (Exception e) {
                    responseBodyMap = new HashMap();
                    responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode());
                    responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2));
                    err = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
                    asyncContext.onComplete(err);
                    long endTime = System.currentTimeMillis();
                    this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)unSubTopicList), unSubscribeUrl, e});
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
                    this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                }
            }
            this.updateMetadata();
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    private void registerClient(HttpEventWrapper requestWrapper, String consumerGroup, List<String> topicList, String url) {
        Map requestHeaderMap = requestWrapper.getSysHeaderMap();
        for (String topic : topicList) {
            Client client = new Client();
            client.env = requestHeaderMap.get("env").toString();
            client.idc = requestHeaderMap.get("idc").toString();
            client.sys = requestHeaderMap.get("sys").toString();
            client.ip = requestHeaderMap.get("ip").toString();
            client.pid = requestHeaderMap.get("pid").toString();
            client.consumerGroup = consumerGroup;
            client.topic = topic;
            client.url = url;
            client.lastUpTime = new Date();
            String groupTopicKey = client.consumerGroup + "@" + client.topic;
            if (this.eventMeshHTTPServer.localClientInfoMapping.containsKey(groupTopicKey)) {
                List<Client> localClients = this.eventMeshHTTPServer.localClientInfoMapping.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.url, (CharSequence)client.url)) continue;
                    isContains = true;
                    localClient.lastUpTime = client.lastUpTime;
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.eventMeshHTTPServer.localClientInfoMapping.put(groupTopicKey, clients);
        }
    }
}

