/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.WebhookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSubscribeEventProcessor
extends AbstractEventProcessor {
    public Logger httpLogger = LoggerFactory.getLogger((String)"http");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");

    public LocalSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpEventWrapper> asyncContext) throws Exception {
        HashMap<String, Object> responseBodyMap;
        HttpEventWrapper requestWrapper = asyncContext.getRequest();
        this.httpLogger.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        Map userRequestHeaderMap = requestWrapper.getHeaderMap();
        String requestIp = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        userRequestHeaderMap.put("ip", requestIp);
        requestWrapper.buildSysHeaderForClient();
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        responseHeaderMap.put("uri", requestWrapper.getRequestURI());
        responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster);
        responseHeaderMap.put("eventmeship", IPUtils.getLocalAddress());
        responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv);
        responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        if (StringUtils.isBlank((CharSequence)sysHeaderMap.get("idc").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("pid").toString()) || !StringUtils.isNumeric((CharSequence)sysHeaderMap.get("pid").toString()) || StringUtils.isBlank((CharSequence)sysHeaderMap.get("sys").toString())) {
            HashMap<String, Object> responseBodyMap2 = new HashMap<String, Object>();
            responseBodyMap2.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode());
            responseBodyMap2.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap2);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        byte[] requestBody = requestWrapper.getBody();
        Map requestBodyMap = (Map)JsonUtils.deserialize((String)new String(requestBody), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (requestBodyMap.get("url") == null || requestBodyMap.get("topic") == null || requestBodyMap.get("consumerGroup") == null) {
            HashMap<String, Object> responseBodyMap3 = new HashMap<String, Object>();
            responseBodyMap3.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap3.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg());
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap3);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        String url = requestBodyMap.get("url").toString();
        String consumerGroup = requestBodyMap.get("consumerGroup").toString();
        String topic = JsonUtils.serialize(requestBodyMap.get("topic"));
        List subscriptionList = (List)JsonUtils.deserialize((String)topic, (TypeReference)new TypeReference<List<SubscriptionItem>>(){});
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerSecurityEnable) {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String user = sysHeaderMap.get("username").toString();
            String pass = sysHeaderMap.get("passwd").toString();
            String subsystem = sysHeaderMap.get("sys").toString();
            for (SubscriptionItem item : subscriptionList) {
                try {
                    Acl.doAclCheckInHttpReceive(remoteAddr, user, pass, subsystem, item.getTopic(), requestWrapper.getRequestURI());
                }
                catch (Exception e) {
                    HashMap<String, Object> responseBodyMap4 = new HashMap<String, Object>();
                    responseBodyMap4.put("retCode", EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode());
                    responseBodyMap4.put("retMsg", EventMeshRetCode.EVENTMESH_ACL_ERR.getErrMsg());
                    HttpEventWrapper responseWrapper = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap4);
                    asyncContext.onComplete(responseWrapper);
                    this.aclLogger.warn("CLIENT HAS NO PERMISSION,SubscribeProcessor subscribe failed", (Throwable)e);
                    return;
                }
            }
        }
        try {
            if (!IPUtils.isValidDomainOrIp((String)url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIpv4BlackList, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIpv6BlackList)) {
                this.httpLogger.error("subscriber url {} is not valid", (Object)url);
                HashMap<String, Object> responseBodyMap5 = new HashMap<String, Object>();
                responseBodyMap5.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
                responseBodyMap5.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " invalid URL: " + url);
                HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap5);
                asyncContext.onComplete(responseWrapper);
                return;
            }
        }
        catch (Exception e) {
            this.httpLogger.error("subscriber url {} is not valid, error {}", (Object)url, (Object)e.getMessage());
            responseBodyMap = new HashMap<String, Object>();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " invalid URL: " + url);
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        boolean isWebhookAllowed = WebhookUtil.obtainDeliveryAgreement(this.eventMeshHTTPServer.httpClientPool.getClient(), url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshWebhookOrigin);
        if (!isWebhookAllowed) {
            this.httpLogger.error("subscriber url {} is not allowed by the target system", (Object)url);
            responseBodyMap = new HashMap();
            responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode());
            responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + "unauthorized webhook URL: " + url);
            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(responseHeaderMap, responseBodyMap);
            asyncContext.onComplete(responseWrapper);
            return;
        }
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.localClientInfoMapping;
        synchronized (concurrentHashMap) {
            this.registerClient(requestWrapper, consumerGroup, subscriptionList, url);
            for (SubscriptionItem subTopic : subscriptionList) {
                List<Client> groupTopicClients = this.eventMeshHTTPServer.localClientInfoMapping.get(consumerGroup + "@" + subTopic.getTopic());
                if (CollectionUtils.isEmpty(groupTopicClients)) {
                    this.httpLogger.error("group {} topic {} clients is empty", (Object)consumerGroup, (Object)subTopic);
                }
                HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                for (Client client : groupTopicClients) {
                    if (idcUrls.containsKey(client.idc)) {
                        ((List)idcUrls.get(client.idc)).add(StringUtils.deleteWhitespace((String)client.url));
                        continue;
                    }
                    ArrayList<String> urls = new ArrayList<String>();
                    urls.add(client.url);
                    idcUrls.put(client.idc, urls);
                }
                ConsumerGroupConf consumerGroupConf = this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup);
                if (consumerGroupConf == null) {
                    consumerGroupConf = new ConsumerGroupConf(consumerGroup);
                    ConsumerGroupTopicConf consumeTopicConfig = new ConsumerGroupTopicConf();
                    consumeTopicConfig.setConsumerGroup(consumerGroup);
                    consumeTopicConfig.setTopic(subTopic.getTopic());
                    consumeTopicConfig.setSubscriptionItem(subTopic);
                    consumeTopicConfig.setUrls(new HashSet<String>(Arrays.asList(url)));
                    consumeTopicConfig.setIdcUrls(idcUrls);
                    HashMap<String, ConsumerGroupTopicConf> map = new HashMap<String, ConsumerGroupTopicConf>();
                    map.put(subTopic.getTopic(), consumeTopicConfig);
                    consumerGroupConf.setConsumerGroupTopicConf(map);
                } else {
                    Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                    if (!map.containsKey(subTopic.getTopic())) {
                        ConsumerGroupTopicConf newTopicConf = new ConsumerGroupTopicConf();
                        newTopicConf.setConsumerGroup(consumerGroup);
                        newTopicConf.setTopic(subTopic.getTopic());
                        newTopicConf.setSubscriptionItem(subTopic);
                        newTopicConf.setUrls(new HashSet<String>(Arrays.asList(url)));
                        newTopicConf.setIdcUrls(idcUrls);
                        map.put(subTopic.getTopic(), newTopicConf);
                    }
                    for (String key : map.keySet()) {
                        if (!StringUtils.equals((CharSequence)subTopic.getTopic(), (CharSequence)key)) continue;
                        ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                        latestTopicConf.setConsumerGroup(consumerGroup);
                        latestTopicConf.setTopic(subTopic.getTopic());
                        latestTopicConf.setSubscriptionItem(subTopic);
                        latestTopicConf.setUrls(new HashSet<String>(Arrays.asList(url)));
                        ConsumerGroupTopicConf currentTopicConf = map.get(key);
                        latestTopicConf.getUrls().addAll(currentTopicConf.getUrls());
                        latestTopicConf.setIdcUrls(idcUrls);
                        map.put(key, latestTopicConf);
                    }
                }
                this.eventMeshHTTPServer.localConsumerGroupMapping.put(consumerGroup, consumerGroupConf);
            }
            long startTime = System.currentTimeMillis();
            try {
                this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.localConsumerGroupMapping.get(consumerGroup));
                CompleteHandler<HttpEventWrapper> handler = httpEventWrapper -> {
                    try {
                        if (this.httpLogger.isDebugEnabled()) {
                            this.httpLogger.debug("{}", httpEventWrapper);
                        }
                        this.eventMeshHTTPServer.sendResponse(ctx, httpEventWrapper.httpResponse());
                        this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                };
                HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(EventMeshRetCode.SUCCESS);
                asyncContext.onComplete(responseWrapper, handler);
            }
            catch (Exception e) {
                HashMap<String, Object> responseBodyMap6 = new HashMap<String, Object>();
                responseBodyMap6.put("retCode", EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR.getRetCode());
                responseBodyMap6.put("retMsg", EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2));
                HttpEventWrapper err = asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap6);
                asyncContext.onComplete(err);
                long endTime = System.currentTimeMillis();
                this.httpLogger.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)subscriptionList), url, e});
                this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgFailed();
                this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendMsgCost(endTime - startTime);
            }
            this.updateMetadata();
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    private void registerClient(HttpEventWrapper requestWrapper, String consumerGroup, List<SubscriptionItem> subscriptionItems, String url) {
        Map requestHeaderMap = requestWrapper.getSysHeaderMap();
        for (SubscriptionItem item : subscriptionItems) {
            Client client = new Client();
            client.env = requestHeaderMap.get("env").toString();
            client.idc = requestHeaderMap.get("idc").toString();
            client.sys = requestHeaderMap.get("sys").toString();
            client.ip = requestHeaderMap.get("ip").toString();
            client.pid = requestHeaderMap.get("pid").toString();
            client.consumerGroup = consumerGroup;
            client.topic = item.getTopic();
            client.url = url;
            client.lastUpTime = new Date();
            String groupTopicKey = client.consumerGroup + "@" + client.topic;
            if (this.eventMeshHTTPServer.localClientInfoMapping.containsKey(groupTopicKey)) {
                List<Client> localClients = this.eventMeshHTTPServer.localClientInfoMapping.get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.url, (CharSequence)client.url)) continue;
                    isContains = true;
                    localClient.lastUpTime = client.lastUpTime;
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.eventMeshHTTPServer.localClientInfoMapping.put(groupTopicKey, clients);
        }
    }
}

