/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import java.util.Date;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.Heartbeat;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private final EventMeshGrpcServer eventMeshGrpcServer;

    public HeartbeatProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void process(Heartbeat heartbeat, EventEmitter<Response> emitter) throws Exception {
        RequestHeader header = heartbeat.getHeader();
        if (!ServiceUtils.validateHeader(header)) {
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateHeartBeat(heartbeat)) {
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        try {
            this.doAclCheck(heartbeat);
        }
        catch (AclException e) {
            this.aclLogger.warn("CLIENT HAS NO PERMISSION, HeartbeatProcessor failed", (Throwable)e);
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        Heartbeat.ClientType clientType = heartbeat.getClientType();
        if (!Heartbeat.ClientType.SUB.equals((Object)clientType)) {
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        String consumerGroup = heartbeat.getConsumerGroup();
        for (Heartbeat.HeartbeatItem item : heartbeat.getHeartbeatItemsList()) {
            ConsumerGroupClient hbClient = ConsumerGroupClient.builder().env(header.getEnv()).idc(header.getIdc()).sys(header.getSys()).ip(header.getIp()).pid(header.getPid()).consumerGroup(consumerGroup).topic(item.getTopic()).lastUpTime(new Date()).build();
            consumerManager.updateClientTime(hbClient);
        }
        ServiceUtils.sendRespAndDone(StatusCode.SUCCESS, "heartbeat success", emitter);
    }

    private void doAclCheck(Heartbeat heartbeat) throws AclException {
        RequestHeader header = heartbeat.getHeader();
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshServerSecurityEnable) {
            String remoteAdd = header.getIp();
            String user = header.getUsername();
            String pass = header.getPassword();
            String sys = header.getSys();
            int requestCode = RequestCode.HEARTBEAT.getRequestCode();
            for (Heartbeat.HeartbeatItem item : heartbeat.getHeartbeatItemsList()) {
                Acl.doAclCheckInHttpHeartbeat(remoteAdd, user, pass, sys, item.getTopic(), requestCode);
            }
        }
    }
}

