/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTopicConfig
extends ConsumerGroupTopicConfig {
    private final Logger logger = LoggerFactory.getLogger(StreamTopicConfig.class);
    private final Map<String, Map<String, EventEmitter<SimpleMessage>>> idcEmitterMap = new ConcurrentHashMap<String, Map<String, EventEmitter<SimpleMessage>>>();
    private Map<String, List<EventEmitter<SimpleMessage>>> idcEmitters = new ConcurrentHashMap<String, List<EventEmitter<SimpleMessage>>>();
    private List<EventEmitter<SimpleMessage>> totalEmitters = new LinkedList<EventEmitter<SimpleMessage>>();

    public StreamTopicConfig(String consumerGroup, String topic, Subscription.SubscriptionItem.SubscriptionMode subscriptionMode) {
        super(consumerGroup, topic, subscriptionMode, GrpcType.STREAM);
    }

    @Override
    public synchronized void registerClient(ConsumerGroupClient client) {
        if (!client.getGrpcType().equals((Object)this.grpcType)) {
            this.logger.warn("Invalid grpc type: {}, expecting grpc type: {}, can not register client {}", new Object[]{client.getGrpcType(), this.grpcType, client.toString()});
            return;
        }
        String idc = client.getIdc();
        String clientIp = client.getIp();
        String clientPid = client.getPid();
        EventEmitter<SimpleMessage> emitter = client.getEventEmitter();
        Map emitters = this.idcEmitterMap.computeIfAbsent(idc, k -> new HashMap());
        emitters.put(clientIp + ":" + clientPid, emitter);
        this.idcEmitters = this.buildIdcEmitter();
        this.totalEmitters = this.buildTotalEmitter();
    }

    @Override
    public void deregisterClient(ConsumerGroupClient client) {
        String idc = client.getIdc();
        String clientIp = client.getIp();
        String clientPid = client.getPid();
        Map<String, EventEmitter<SimpleMessage>> emitters = this.idcEmitterMap.get(idc);
        if (emitters == null) {
            return;
        }
        emitters.remove(clientIp + ":" + clientPid);
        if (emitters.size() == 0) {
            this.idcEmitterMap.remove(idc);
        }
        this.idcEmitters = this.buildIdcEmitter();
        this.totalEmitters = this.buildTotalEmitter();
    }

    @Override
    public int getSize() {
        return this.totalEmitters.size();
    }

    public String toString() {
        return "StreamConsumeTopicConfig={consumerGroup=" + this.consumerGroup + ",grpcType=" + (Object)((Object)this.grpcType) + ",topic=" + this.topic + "}";
    }

    @Override
    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Subscription.SubscriptionItem.SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    @Override
    public GrpcType getGrpcType() {
        return this.grpcType;
    }

    public Map<String, List<EventEmitter<SimpleMessage>>> getIdcEmitters() {
        return this.idcEmitters;
    }

    public List<EventEmitter<SimpleMessage>> getTotalEmitters() {
        return this.totalEmitters;
    }

    private Map<String, List<EventEmitter<SimpleMessage>>> buildIdcEmitter() {
        HashMap<String, List<EventEmitter<SimpleMessage>>> result = new HashMap<String, List<EventEmitter<SimpleMessage>>>();
        for (Map.Entry<String, Map<String, EventEmitter<SimpleMessage>>> entry : this.idcEmitterMap.entrySet()) {
            LinkedList<EventEmitter<SimpleMessage>> emitterList = new LinkedList<EventEmitter<SimpleMessage>>(entry.getValue().values());
            result.put(entry.getKey(), emitterList);
        }
        return result;
    }

    private List<EventEmitter<SimpleMessage>> buildTotalEmitter() {
        LinkedList<EventEmitter<SimpleMessage>> emitterList = new LinkedList<EventEmitter<SimpleMessage>>();
        for (List<EventEmitter<SimpleMessage>> emitters : this.idcEmitters.values()) {
            emitterList.addAll(emitters);
        }
        return emitterList;
    }
}

