/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.configuration;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.IPUtils;

public class EventMeshGrpcConfiguration
extends CommonConfiguration {
    public int grpcServerPort = 10205;
    public int eventMeshSessionExpiredInMills = 60000;
    public boolean eventMeshServerBatchMsgBatchEnabled = Boolean.TRUE;
    public int eventMeshServerBatchMsgThreadNum = 10;
    public int eventMeshServerSendMsgThreadNum = 8;
    public int eventMeshServerPushMsgThreadNum = 8;
    public int eventMeshServerReplyMsgThreadNum = 8;
    public int eventMeshServerSubscribeMsgThreadNum = 4;
    public int eventMeshServerRegistryThreadNum = 10;
    public int eventMeshServerAdminThreadNum = 2;
    public int eventMeshServerRetryThreadNum = 2;
    public int eventMeshServerPullRegistryInterval = 30000;
    public int eventMeshServerAsyncAccumulationThreshold = 1000;
    public int eventMeshServerRetryBlockQueueSize = 10000;
    public int eventMeshServerBatchBlockQueueSize = 1000;
    public int eventMeshServerSendMsgBlockQueueSize = 1000;
    public int eventMeshServerPushMsgBlockQueueSize = 1000;
    public int eventMeshServerSubscribeMsgBlockQueueSize = 1000;
    public int eventMeshServerBusyCheckInterval = 1000;
    public boolean eventMeshServerConsumerEnabled = false;
    public boolean eventMeshServerUseTls = false;
    public int eventMeshBatchMsgRequestNumPerSecond = 20000;
    public int eventMeshMsgReqNumPerSecond = 15000;
    public String eventMeshIp = IPUtils.getLocalAddress();

    public EventMeshGrpcConfiguration(ConfigurationWrapper configurationWrapper) {
        super(configurationWrapper);
    }

    public void init() {
        super.init();
        if (this.configurationWrapper != null) {
            String eventMeshMsgReqNumPerSecondStr;
            String eventMeshServerUseTlsStr;
            String eventMeshServerRetryThreadNumStr;
            String eventMeshServerConsumerEnabledStr;
            String eventMeshServerBusyCheckIntervalStr;
            String eventMeshServerClientManageBlockQueueSizeStr;
            String eventMeshServerPushMsgBlockQueueSizeStr;
            String eventMeshServerSendMsgBlockQueueSizeStr;
            String eventMeshServerBatchBlockQueueSizeStr;
            String eventMeshServerRetryBlockQueueSizeStr;
            String eventMeshServerAdminThreadNumStr;
            String eventMeshServerPullRegistryIntervalStr;
            String eventMeshServerClientManageThreadNumStr;
            String eventMeshServerRegistryThreadNumStr;
            String eventMeshServerPushMsgThreadNumStr;
            String eventMeshServerReplyMsgThreadNumStr;
            String eventMeshServerSendMsgThreadNumStr;
            String eventMeshServerAsyncAccumulationThresholdStr;
            String eventMeshServerBatchMsgBatchEnableStr;
            String eventMeshServerBatchMsgReqNumPerSecondStr;
            String eventMeshTcpSessionExpiredInMillsStr;
            String httpServerPortStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_GRPC_PORT);
            Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)httpServerPortStr) && StringUtils.isNumeric((CharSequence)httpServerPortStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_GRPC_PORT));
            this.grpcServerPort = Integer.parseInt(StringUtils.deleteWhitespace((String)httpServerPortStr));
            String eventMeshServerBatchMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_THREAD_NUM);
            if (StringUtils.isNotEmpty((CharSequence)eventMeshServerBatchMsgThreadNumStr) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchMsgThreadNumStr)) {
                this.eventMeshServerBatchMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerBatchMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshTcpSessionExpiredInMillsStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME))) && StringUtils.isNumeric((CharSequence)eventMeshTcpSessionExpiredInMillsStr)) {
                this.eventMeshSessionExpiredInMills = Integer.parseInt(eventMeshTcpSessionExpiredInMillsStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBatchMsgReqNumPerSecondStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_REQ_NUM_PER_SECOND))) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchMsgReqNumPerSecondStr)) {
                this.eventMeshBatchMsgRequestNumPerSecond = Integer.parseInt(eventMeshServerBatchMsgReqNumPerSecondStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(eventMeshServerBatchMsgBatchEnableStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_BATCH_ENABLED)))) {
                this.eventMeshServerBatchMsgBatchEnabled = Boolean.parseBoolean(eventMeshServerBatchMsgBatchEnableStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerAsyncAccumulationThresholdStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_ASYNC_ACCUMULATION_THRESHOLD))) && StringUtils.isNumeric((CharSequence)eventMeshServerAsyncAccumulationThresholdStr)) {
                this.eventMeshServerAsyncAccumulationThreshold = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerAsyncAccumulationThresholdStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerSendMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SENDMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerSendMsgThreadNumStr)) {
                this.eventMeshServerSendMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerSendMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerReplyMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_REPLYMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerReplyMsgThreadNumStr)) {
                this.eventMeshServerReplyMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerReplyMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPushMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_PUSHMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerPushMsgThreadNumStr)) {
                this.eventMeshServerPushMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerPushMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRegistryThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_REGISTRY_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerRegistryThreadNumStr)) {
                this.eventMeshServerRegistryThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerRegistryThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerClientManageThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_CLIENTMANAGE_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerClientManageThreadNumStr)) {
                this.eventMeshServerSubscribeMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerClientManageThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPullRegistryIntervalStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_PULL_REGISTRY_INTERVAL))) && StringUtils.isNumeric((CharSequence)eventMeshServerPullRegistryIntervalStr)) {
                this.eventMeshServerPullRegistryInterval = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerPullRegistryIntervalStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerAdminThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_ADMIN_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerAdminThreadNumStr)) {
                this.eventMeshServerAdminThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerAdminThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRetryBlockQueueSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_RETRY_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerRetryBlockQueueSizeStr)) {
                this.eventMeshServerRetryBlockQueueSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerRetryBlockQueueSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBatchBlockQueueSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_BATCHMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchBlockQueueSizeStr)) {
                this.eventMeshServerBatchBlockQueueSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerBatchBlockQueueSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerSendMsgBlockQueueSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SENDMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerSendMsgBlockQueueSizeStr)) {
                this.eventMeshServerSendMsgBlockQueueSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerSendMsgBlockQueueSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPushMsgBlockQueueSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_PUSHMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerPushMsgBlockQueueSizeStr)) {
                this.eventMeshServerPushMsgBlockQueueSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerPushMsgBlockQueueSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerClientManageBlockQueueSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_CLIENTM_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerClientManageBlockQueueSizeStr)) {
                this.eventMeshServerSubscribeMsgBlockQueueSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerClientManageBlockQueueSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBusyCheckIntervalStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_BUSY_CHECK_INTERVAL))) && StringUtils.isNumeric((CharSequence)eventMeshServerBusyCheckIntervalStr)) {
                this.eventMeshServerBusyCheckInterval = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerBusyCheckIntervalStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerConsumerEnabledStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_CONSUMER_ENABLED)))) {
                this.eventMeshServerConsumerEnabled = Boolean.parseBoolean(StringUtils.deleteWhitespace((String)eventMeshServerConsumerEnabledStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRetryThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_RETRY_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerRetryThreadNumStr)) {
                this.eventMeshServerRetryThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerRetryThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerUseTlsStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_TLS_ENABLED)))) {
                this.eventMeshServerUseTls = Boolean.parseBoolean(StringUtils.deleteWhitespace((String)eventMeshServerUseTlsStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshMsgReqNumPerSecondStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECOND))) && StringUtils.isNumeric((CharSequence)eventMeshMsgReqNumPerSecondStr)) {
                this.eventMeshMsgReqNumPerSecond = Integer.parseInt(eventMeshMsgReqNumPerSecondStr);
            }
        }
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_SERVER_GRPC_PORT = "eventMesh.server.grpc.port";
        public static String KEYS_EVENTMESH_SERVER_SESSION_EXPIRED_TIME = "eventMesh.server.session.expiredInMills";
        public static String KEYS_EVENTMESH_BATCHMSG_THREAD_NUM = "eventMesh.server.batchmsg.threads.num";
        public static String KEYS_EVENTMESH_BATCHMSG_REQ_NUM_PER_SECOND = "eventMesh.server.batchmsg.reqNumPerSecond";
        public static String KEYS_EVENTMESH_BATCHMSG_BATCH_ENABLED = "eventMesh.server.batchmsg.batch.enabled";
        public static String KEYS_EVENTMESH_ASYNC_ACCUMULATION_THRESHOLD = "eventMesh.server.async.accumulation.threshold";
        public static String KEY_EVENTMESH_BUSY_CHECK_INTERVAL = "eventMesh.server.busy.check.interval";
        public static String KEYS_EVENTMESH_SENDMSG_THREAD_NUM = "eventMesh.server.sendmsg.threads.num";
        public static String KEYS_EVENTMESH_REPLYMSG_THREAD_NUM = "eventMesh.server.replymsg.threads.num";
        public static String KEYS_EVENTMESH_PUSHMSG_THREAD_NUM = "eventMesh.server.pushmsg.threads.num";
        public static String KEYS_EVENTMESH_REGISTRY_THREAD_NUM = "eventMesh.server.registry.threads.num";
        public static String KEYS_EVENTMESH_CLIENTMANAGE_THREAD_NUM = "eventMesh.server.clientmanage.threads.num";
        public static String KEYS_EVENTMESH_ADMIN_THREAD_NUM = "eventMesh.server.admin.threads.num";
        public static String KEY_EVENTMESH_RETRY_THREAD_NUM = "eventMesh.server.retry.threads.num";
        public static String KEYS_EVENTMESH_PULL_REGISTRY_INTERVAL = "eventMesh.server.pull.registry.interval";
        public static String KEY_EVENTMESH_RETRY_BLOCKQ_SIZE = "eventMesh.server.retry.blockQ.size";
        public static String KEY_EVENTMESH_BATCHMSG_BLOCKQ_SIZE = "eventMesh.server.batchmsg.blockQ.size";
        public static String KEY_EVENTMESH_SENDMSG_BLOCKQ_SIZE = "eventMesh.server.sendmsg.blockQ.size";
        public static String KEY_EVENTMESH_PUSHMSG_BLOCKQ_SIZE = "eventMesh.server.pushmsg.blockQ.size";
        public static String KEY_EVENTMESH_CLIENTM_BLOCKQ_SIZE = "eventMesh.server.clientM.blockQ.size";
        public static String KEY_EVENTMESH_CONSUMER_ENABLED = "eventMesh.server.consumer.enabled";
        public static String KEY_EVENTMESH_TLS_ENABLED = "eventMesh.server.useTls.enabled";
        public static String KEY_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECOND = "eventMesh.server.http.msgReqnumPerSecond";

        ConfKeys() {
        }
    }
}

