/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.controller;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.eventmesh.admin.rocketmq.controller.AdminController;
import org.apache.eventmesh.runtime.admin.handler.QueryRecommendEventMeshHandler;
import org.apache.eventmesh.runtime.admin.handler.RedirectClientByIpPortHandler;
import org.apache.eventmesh.runtime.admin.handler.RedirectClientByPathHandler;
import org.apache.eventmesh.runtime.admin.handler.RedirectClientBySubSystemHandler;
import org.apache.eventmesh.runtime.admin.handler.RejectAllClientHandler;
import org.apache.eventmesh.runtime.admin.handler.RejectClientByIpPortHandler;
import org.apache.eventmesh.runtime.admin.handler.RejectClientBySubSystemHandler;
import org.apache.eventmesh.runtime.admin.handler.ShowClientBySystemHandler;
import org.apache.eventmesh.runtime.admin.handler.ShowClientHandler;
import org.apache.eventmesh.runtime.admin.handler.ShowListenClientByTopicHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManageController {
    private static final Logger logger = LoggerFactory.getLogger(ClientManageController.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private AdminController adminController;

    public ClientManageController(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void start() throws IOException {
        int port = this.eventMeshTCPServer.getEventMeshTCPConfiguration().eventMeshServerAdminPort;
        HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
        server.createContext("/clientManage/showClient", new ShowClientHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/showClientBySystem", new ShowClientBySystemHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/rejectAllClient", new RejectAllClientHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/rejectClientByIpPort", new RejectClientByIpPortHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/rejectClientBySubSystem", new RejectClientBySubSystemHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/redirectClientBySubSystem", new RedirectClientBySubSystemHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/redirectClientByPath", new RedirectClientByPathHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/redirectClientByIpPort", new RedirectClientByIpPortHandler(this.eventMeshTCPServer));
        server.createContext("/clientManage/showListenClientByTopic", new ShowListenClientByTopicHandler(this.eventMeshTCPServer));
        server.createContext("/eventMesh/recommend", new QueryRecommendEventMeshHandler(this.eventMeshTCPServer));
        this.adminController = new AdminController();
        this.adminController.run(server);
        server.start();
        logger.info("ClientManageController start success, port:{}", (Object)port);
    }
}

