/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.IPUtils;

public class CommonConfiguration {
    public String eventMeshEnv = "P";
    public String eventMeshIDC = "FT";
    public String eventMeshCluster = "LS";
    public String eventMeshName = "";
    public String sysID = "5477";
    public String eventMeshConnectorPluginType = "rocketmq";
    public String eventMeshSecurityPluginType = "security";
    public String eventMeshRegistryPluginType = "namesrv";
    public List<String> eventMeshMetricsPluginType;
    public String eventMeshTracePluginType;
    public String namesrvAddr = "";
    public String eventMeshRegistryPluginUsername = "";
    public String eventMeshRegistryPluginPassword = "";
    public Integer eventMeshRegisterIntervalInMills = 10000;
    public Integer eventMeshFetchRegistryAddrInterval = 10000;
    public String eventMeshServerIp = null;
    public boolean eventMeshServerSecurityEnable = false;
    public boolean eventMeshServerRegistryEnable = false;
    public boolean eventMeshServerTraceEnable = false;
    protected ConfigurationWrapper configurationWrapper;
    public String eventMeshWebhookOrigin = "eventmesh." + this.eventMeshIDC;

    public CommonConfiguration(ConfigurationWrapper configurationWrapper) {
        this.configurationWrapper = configurationWrapper;
    }

    public void init() {
        if (this.configurationWrapper != null) {
            this.eventMeshEnv = this.checkNotEmpty(ConfKeys.KEYS_EVENTMESH_ENV);
            this.sysID = this.checkNumeric(ConfKeys.KEYS_EVENTMESH_SYSID);
            this.eventMeshCluster = this.checkNotEmpty(ConfKeys.KEYS_EVENTMESH_SERVER_CLUSTER);
            this.eventMeshName = this.checkNotEmpty(ConfKeys.KEYS_EVENTMESH_SERVER_NAME);
            this.eventMeshIDC = this.checkNotEmpty(ConfKeys.KEYS_EVENTMESH_IDC);
            this.eventMeshServerIp = this.get(ConfKeys.KEYS_EVENTMESH_SERVER_HOST_IP, IPUtils::getLocalAddress);
            this.eventMeshConnectorPluginType = this.checkNotEmpty(ConfKeys.KEYS_ENENTMESH_CONNECTOR_PLUGIN_TYPE);
            this.eventMeshServerSecurityEnable = Boolean.parseBoolean(this.get(ConfKeys.KEYS_EVENTMESH_SECURITY_ENABLED, () -> "false"));
            this.eventMeshSecurityPluginType = this.checkNotEmpty(ConfKeys.KEYS_ENENTMESH_SECURITY_PLUGIN_TYPE);
            this.eventMeshServerRegistryEnable = Boolean.parseBoolean(this.get(ConfKeys.KEYS_EVENTMESH_REGISTRY_ENABLED, () -> "false"));
            this.eventMeshRegistryPluginType = this.checkNotEmpty(ConfKeys.KEYS_ENENTMESH_REGISTRY_PLUGIN_TYPE);
            this.namesrvAddr = this.checkNotEmpty(ConfKeys.KEYS_EVENTMESH_REGISTRY_PULGIN_SERVER_ADDR);
            this.eventMeshRegistryPluginUsername = Optional.ofNullable(this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_REGISTRY_PULGIN_USERNAME)).orElse("");
            this.eventMeshRegistryPluginPassword = Optional.ofNullable(this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_REGISTRY_PULGIN_PASSWORD)).orElse("");
            String metricsPluginType = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_METRICS_PLUGIN_TYPE);
            if (StringUtils.isNotEmpty((CharSequence)metricsPluginType)) {
                this.eventMeshMetricsPluginType = Arrays.stream(metricsPluginType.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
            }
            this.eventMeshServerTraceEnable = Boolean.parseBoolean(this.get(ConfKeys.KEYS_EVENTMESH_TRACE_ENABLED, () -> "false"));
            this.eventMeshTracePluginType = this.checkNotEmpty(ConfKeys.KEYS_EVENTMESH_TRACE_PLUGIN_TYPE);
        }
    }

    private String checkNotEmpty(String key) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)value), (Object)(key + " is invalidated"));
        return value;
    }

    private String checkNumeric(String key) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)value) && StringUtils.isNumeric((CharSequence)value) ? 1 : 0) != 0, (Object)(key + " is invalidated"));
        return value;
    }

    private String get(String key, Supplier<String> defaultValueSupplier) {
        String value = this.configurationWrapper.getProp(key);
        if (value != null) {
            value = StringUtils.deleteWhitespace((String)value);
        }
        return StringUtils.isEmpty((CharSequence)value) ? defaultValueSupplier.get() : value;
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_ENV = "eventMesh.server.env";
        public static String KEYS_EVENTMESH_IDC = "eventMesh.server.idc";
        public static String KEYS_EVENTMESH_SYSID = "eventMesh.sysid";
        public static String KEYS_EVENTMESH_SERVER_CLUSTER = "eventMesh.server.cluster";
        public static String KEYS_EVENTMESH_SERVER_NAME = "eventMesh.server.name";
        public static String KEYS_EVENTMESH_SERVER_HOST_IP = "eventMesh.server.hostIp";
        public static String KEYS_EVENTMESH_SERVER_REGISTER_INTERVAL = "eventMesh.server.registry.registerIntervalInMills";
        public static String KEYS_EVENTMESH_SERVER_FETCH_REGISTRY_ADDR_INTERVAL = "eventMesh.server.registry.fetchRegistryAddrIntervalInMills";
        public static String KEYS_ENENTMESH_CONNECTOR_PLUGIN_TYPE = "eventMesh.connector.plugin.type";
        public static String KEYS_EVENTMESH_SECURITY_ENABLED = "eventMesh.server.security.enabled";
        public static String KEYS_ENENTMESH_SECURITY_PLUGIN_TYPE = "eventMesh.security.plugin.type";
        public static String KEYS_EVENTMESH_REGISTRY_ENABLED = "eventMesh.registry.plugin.enabled";
        public static String KEYS_ENENTMESH_REGISTRY_PLUGIN_TYPE = "eventMesh.registry.plugin.type";
        public static String KEYS_EVENTMESH_REGISTRY_PULGIN_SERVER_ADDR = "eventMesh.registry.plugin.server-addr";
        public static String KEYS_EVENTMESH_REGISTRY_PULGIN_USERNAME = "eventMesh.registry.plugin.username";
        public static String KEYS_EVENTMESH_REGISTRY_PULGIN_PASSWORD = "eventMesh.registry.plugin.password";
        public static String KEYS_EVENTMESH_METRICS_PLUGIN_TYPE = "eventMesh.metrics.plugin";
        public static String KEYS_EVENTMESH_TRACE_ENABLED = "eventMesh.server.trace.enabled";
        public static String KEYS_EVENTMESH_TRACE_PLUGIN_TYPE = "eventMesh.trace.plugin";

        ConfKeys() {
        }
    }
}

