/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.DoubleMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.resources.Resource;

final class MinMaxSumCountAggregatorFactory
implements AggregatorFactory {
    static final AggregatorFactory INSTANCE = new MinMaxSumCountAggregatorFactory();

    private MinMaxSumCountAggregatorFactory() {
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongMinMaxSumCountAggregator(resource, instrumentationLibraryInfo, descriptor);
            }
            case DOUBLE: {
                return new DoubleMinMaxSumCountAggregator(resource, instrumentationLibraryInfo, descriptor);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

