/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.file.FileChangeContext;
import org.apache.eventmesh.common.file.FileChangeListener;
import org.apache.eventmesh.common.file.WatchFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWrapper {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String directoryPath;
    private final String fileName;
    private final Properties properties = new Properties();
    private final String file;
    private final boolean reload;
    private final FileChangeListener fileChangeListener = new FileChangeListener(){

        @Override
        public void onChanged(FileChangeContext changeContext) {
            ConfigurationWrapper.this.load();
        }

        @Override
        public boolean support(FileChangeContext changeContext) {
            return changeContext.getWatchEvent().context().toString().contains(ConfigurationWrapper.this.fileName);
        }
    };

    public ConfigurationWrapper(String directoryPath, String fileName, boolean reload) {
        this.directoryPath = directoryPath;
        this.fileName = fileName;
        this.file = directoryPath + File.separator + fileName;
        this.reload = reload;
        this.init();
    }

    private void init() {
        this.load();
        if (this.reload) {
            WatchFileManager.registerFileChangeListener(this.directoryPath, this.fileChangeListener);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.logger.info("Configuration reload task closed");
                WatchFileManager.deregisterFileChangeListener(this.directoryPath);
            }));
        }
    }

    private void load() {
        try {
            this.logger.info("loading config: {}", (Object)this.file);
            this.properties.load(new BufferedReader(new FileReader(this.file)));
        }
        catch (IOException e) {
            this.logger.error("loading properties [{}] error", (Object)this.file, (Object)e);
        }
    }

    public String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : this.properties.getProperty(key, null);
    }

    public int getIntProp(String configKey, int defaultValue) {
        String configValue = StringUtils.deleteWhitespace((String)this.getProp(configKey));
        if (StringUtils.isEmpty((CharSequence)configValue)) {
            return defaultValue;
        }
        Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)configValue), (Object)String.format("key:%s, value:%s error", configKey, configValue));
        return Integer.parseInt(configValue);
    }

    public boolean getBoolProp(String configKey, boolean defaultValue) {
        String configValue = StringUtils.deleteWhitespace((String)this.getProp(configKey));
        if (StringUtils.isEmpty((CharSequence)configValue)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(configValue);
    }
}

