/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.loadbalance;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.LoadBalanceType;
import org.apache.eventmesh.common.loadbalance.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightRoundRobinLoadBalanceSelector<T>
implements LoadBalanceSelector<T> {
    private final Logger logger = LoggerFactory.getLogger(WeightRoundRobinLoadBalanceSelector.class);
    private final List<Weight<T>> clusterGroup;
    private final int totalWeight;

    public WeightRoundRobinLoadBalanceSelector(List<Weight<T>> clusterGroup) {
        int totalWeight = 0;
        for (Weight<T> weight : clusterGroup) {
            totalWeight += weight.getWeight();
        }
        this.clusterGroup = clusterGroup;
        this.totalWeight = totalWeight;
    }

    @Override
    public T select() {
        if (CollectionUtils.isEmpty(this.clusterGroup)) {
            this.logger.warn("No servers available");
            return null;
        }
        Weight<T> targetWeight = null;
        for (Weight<T> weight : this.clusterGroup) {
            weight.increaseCurrentWeight();
            if (targetWeight != null && targetWeight.getCurrentWeight().get() >= weight.getCurrentWeight().get()) continue;
            targetWeight = weight;
        }
        targetWeight.decreaseTotal(this.totalWeight);
        return targetWeight.getTarget();
    }

    @Override
    public LoadBalanceType getType() {
        return LoadBalanceType.WEIGHT_ROUND_ROBIN;
    }
}

