/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.standalone.consumer;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.connector.standalone.broker.StandaloneBroker;
import org.apache.eventmesh.connector.standalone.broker.model.TopicMetadata;
import org.apache.eventmesh.connector.standalone.broker.task.SubScribeTask;

public class StandaloneConsumer
implements Consumer {
    private StandaloneBroker standaloneBroker = StandaloneBroker.getInstance();
    private EventListener listener;
    private AtomicBoolean isStarted;
    private final ConcurrentHashMap<String, SubScribeTask> subscribeTaskTable = new ConcurrentHashMap(16);
    private ExecutorService consumeExecutorService;

    public StandaloneConsumer(Properties properties) {
        this.isStarted = new AtomicBoolean(false);
        this.consumeExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"StandaloneConsumerThread");
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public boolean isClosed() {
        return !this.isStarted.get();
    }

    public void start() {
        this.isStarted.compareAndSet(false, true);
    }

    public void shutdown() {
        this.isStarted.compareAndSet(true, false);
        this.subscribeTaskTable.forEach((topic, subScribeTask) -> subScribeTask.shutdown());
        this.subscribeTaskTable.clear();
    }

    public void init(Properties keyValue) throws Exception {
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        cloudEvents.forEach(cloudEvent -> this.standaloneBroker.updateOffset(new TopicMetadata(cloudEvent.getSubject()), (Long)cloudEvent.getExtension("offset")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String topic) throws Exception {
        if (this.subscribeTaskTable.containsKey(topic)) {
            return;
        }
        ConcurrentHashMap<String, SubScribeTask> concurrentHashMap = this.subscribeTaskTable;
        synchronized (concurrentHashMap) {
            this.standaloneBroker.createTopicIfAbsent(topic);
            SubScribeTask subScribeTask = new SubScribeTask(topic, this.standaloneBroker, this.listener);
            this.subscribeTaskTable.put(topic, subScribeTask);
            this.consumeExecutorService.execute(subScribeTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topic) {
        if (!this.subscribeTaskTable.containsKey(topic)) {
            return;
        }
        ConcurrentHashMap<String, SubScribeTask> concurrentHashMap = this.subscribeTaskTable;
        synchronized (concurrentHashMap) {
            SubScribeTask subScribeTask = this.subscribeTaskTable.get(topic);
            subScribeTask.shutdown();
            this.subscribeTaskTable.remove(topic);
        }
    }

    public void registerEventListener(EventListener listener) {
        this.listener = listener;
    }
}

