/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.eventmesh.common.exception.JsonException;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String serialize(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("serialize to json error", e);
        }
    }

    public static <T> T deserialize(String str, Class<T> clz) {
        try {
            return (T)OBJECT_MAPPER.readValue(str, clz);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to object error", e);
        }
    }

    public static <T> T deserialize(String str, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(str, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to object error", e);
        }
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

