/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.utils;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;

public class CloudEventUtils {
    public static SendResult convertSendResult(org.apache.rocketmq.client.producer.SendResult rmqResult) {
        SendResult sendResult = new SendResult();
        sendResult.setTopic(rmqResult.getMessageQueue().getTopic());
        sendResult.setMessageId(rmqResult.getMsgId());
        return sendResult;
    }

    public static Message msgConvert(MessageExt rmqMsg) {
        Message message = new Message();
        if (rmqMsg.getTopic() != null) {
            message.setTopic(rmqMsg.getTopic());
        }
        if (rmqMsg.getKeys() != null) {
            message.setKeys(rmqMsg.getKeys());
        }
        if (rmqMsg.getTags() != null) {
            message.setTags(rmqMsg.getTags());
        }
        if (rmqMsg.getBody() != null) {
            message.setBody(rmqMsg.getBody());
        }
        Set entries = rmqMsg.getProperties().entrySet();
        for (Map.Entry entry : entries) {
            MessageAccessor.putProperty((Message)message, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        if (rmqMsg.getMsgId() != null) {
            MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("messageid"), (String)rmqMsg.getMsgId());
        }
        if (rmqMsg.getTopic() != null) {
            MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("destination"), (String)rmqMsg.getTopic());
        }
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("bornhost"), (String)String.valueOf(rmqMsg.getBornHost()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("borntimestamp"), (String)String.valueOf(rmqMsg.getBornTimestamp()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("storehost"), (String)String.valueOf(rmqMsg.getStoreHost()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("storetimestamp"), (String)String.valueOf(rmqMsg.getStoreTimestamp()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("queueid"), (String)String.valueOf(rmqMsg.getQueueId()));
        MessageAccessor.putProperty((Message)message, (String)CloudEventUtils.buildCloudEventPropertyKey("queueoffset"), (String)String.valueOf(rmqMsg.getQueueOffset()));
        for (String sysPropKey : MessageConst.STRING_HASH_SET) {
            if (!StringUtils.isNotEmpty((CharSequence)message.getProperty(sysPropKey))) continue;
            String prop = message.getProperty(sysPropKey);
            String tmpPropKey = sysPropKey.toLowerCase().replaceAll("_", "99");
            MessageAccessor.putProperty((Message)message, (String)tmpPropKey, (String)prop);
            message.getProperties().remove(sysPropKey);
        }
        return message;
    }

    private static String buildCloudEventPropertyKey(String propName) {
        return propName;
    }

    public static MessageExt msgConvertExt(Message message) {
        MessageExt rmqMessageExt = new MessageExt();
        try {
            if (message.getKeys() != null) {
                rmqMessageExt.setKeys(message.getKeys());
            }
            if (message.getTags() != null) {
                rmqMessageExt.setTags(message.getTags());
            }
            if (message.getBody() != null) {
                rmqMessageExt.setBody(message.getBody());
            }
            rmqMessageExt.setTopic(message.getTopic());
            int queueId = Integer.parseInt(message.getProperty(CloudEventUtils.buildCloudEventPropertyKey("queueid")));
            long queueOffset = Long.parseLong(message.getProperty(CloudEventUtils.buildCloudEventPropertyKey("queueoffset")));
            rmqMessageExt.setQueueId(queueId);
            rmqMessageExt.setQueueOffset(queueOffset);
            Map properties = message.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                MessageAccessor.putProperty((Message)rmqMessageExt, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rmqMessageExt;
    }
}

