/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWrapper {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long TIME_INTERVAL = 30000L;
    private String file;
    private Properties properties = new Properties();
    private boolean reload;
    private ScheduledExecutorService configLoader = ThreadPoolFactory.createSingleScheduledExecutor("eventMesh-configLoader-");

    public ConfigurationWrapper(String file, boolean reload) {
        this.file = file;
        this.reload = reload;
        this.init();
    }

    private void init() {
        this.load();
        if (this.reload) {
            this.configLoader.scheduleAtFixedRate(this::load, 30000L, 30000L, TimeUnit.MILLISECONDS);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.logger.info("Configuration reload task closed");
                this.configLoader.shutdownNow();
            }));
        }
    }

    private void load() {
        try {
            this.logger.info("loading config: {}", (Object)this.file);
            this.properties.load(new BufferedReader(new FileReader(this.file)));
        }
        catch (IOException e) {
            this.logger.error("loading properties [{}] error", (Object)this.file, (Object)e);
        }
    }

    public String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : this.properties.getProperty(key, null);
    }

    public int getIntProp(String configKey, int defaultValue) {
        String configValue = StringUtils.deleteWhitespace((String)this.getProp(configKey));
        if (StringUtils.isEmpty((CharSequence)configValue)) {
            return defaultValue;
        }
        Preconditions.checkState((boolean)StringUtils.isNumeric((CharSequence)configValue), (Object)String.format("key:%s, value:%s error", configKey, configValue));
        return Integer.parseInt(configValue);
    }

    public boolean getBoolProp(String configKey, boolean defaultValue) {
        String configValue = StringUtils.deleteWhitespace((String)this.getProp(configKey));
        if (StringUtils.isEmpty((CharSequence)configValue)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(configValue);
    }
}

