/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage.resolver.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageRequestHeader;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class SendMessageRequestProtocolResolver {
    public static CloudEvent buildEvent(Header header, Body body) throws ProtocolHandleException {
        try {
            SendMessageRequestHeader sendMessageRequestHeader = (SendMessageRequestHeader)header;
            SendMessageRequestBody sendMessageRequestBody = (SendMessageRequestBody)body;
            String protocolType = sendMessageRequestHeader.getProtocolType();
            String protocolDesc = sendMessageRequestHeader.getProtocolDesc();
            String protocolVersion = sendMessageRequestHeader.getProtocolVersion();
            String code = sendMessageRequestHeader.getCode();
            String env = sendMessageRequestHeader.getEnv();
            String idc = sendMessageRequestHeader.getIdc();
            String ip = sendMessageRequestHeader.getIp();
            String pid = sendMessageRequestHeader.getPid();
            String sys = sendMessageRequestHeader.getSys();
            String username = sendMessageRequestHeader.getUsername();
            String passwd = sendMessageRequestHeader.getPasswd();
            ProtocolVersion version = sendMessageRequestHeader.getVersion();
            String language = sendMessageRequestHeader.getLanguage();
            String content = sendMessageRequestBody.getContent();
            CloudEvent event = null;
            if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
                io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v1();
                cloudEventBuilder = cloudEventBuilder.withId(sendMessageRequestBody.getBizSeqNo()).withSubject(sendMessageRequestBody.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("code", code).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("version", version.getVersion()).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("bizseqno", sendMessageRequestBody.getBizSeqNo()).withExtension("uniqueid", sendMessageRequestBody.getUniqueId()).withExtension("producergroup", sendMessageRequestBody.getProducerGroup()).withExtension("ttl", sendMessageRequestBody.getTtl());
                if (StringUtils.isNotEmpty((CharSequence)sendMessageRequestBody.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", sendMessageRequestBody.getTag());
                }
                event = cloudEventBuilder.build();
            } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
                CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v03();
                cloudEventBuilder = cloudEventBuilder.withId(sendMessageRequestBody.getBizSeqNo()).withSubject(sendMessageRequestBody.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("code", code).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("version", version.getVersion()).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("bizseqno", sendMessageRequestBody.getBizSeqNo()).withExtension("uniqueid", sendMessageRequestBody.getUniqueId()).withExtension("producergroup", sendMessageRequestBody.getProducerGroup()).withExtension("ttl", sendMessageRequestBody.getTtl());
                if (StringUtils.isNotEmpty((CharSequence)sendMessageRequestBody.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", sendMessageRequestBody.getTag());
                }
                event = cloudEventBuilder.build();
            }
            return event;
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), e.getCause());
        }
    }
}

