/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.metrics.prometheus.metrics;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;

public final class PrometheusHttpExporter {
    public static void export(String name, HttpSummaryMetrics summaryMetrics) {
        Meter meter = GlobalMeterProvider.getMeter((String)name);
        meter.doubleValueObserverBuilder("eventmesh.http.request.tps.max").setDescription("max TPS of HTTP.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.maxHTTPTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.request.tps.avg").setDescription("avg TPS of HTTP.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgHTTPTPS(), Labels.empty())).build();
        meter.longValueObserverBuilder("eventmesh.http.request.cost.max").setDescription("max cost of HTTP.").setUnit("HTTP").setUpdater(result -> result.observe(summaryMetrics.maxHTTPCost(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.request.cost.avg").setDescription("avg cost of HTTP.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgHTTPCost(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.body.decode.cost.avg").setDescription("avg body decode cost of HTTP.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgHTTPBodyDecodeCost(), Labels.empty())).build();
        meter.longValueObserverBuilder("eventmesh.http.request.discard.num").setDescription("http request discard num.").setUnit("HTTP").setUpdater(result -> result.observe(summaryMetrics.getHttpDiscard(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.batch.send.message.tps.max").setDescription("max of batch send message tps.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.maxSendBatchMsgTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.batch.send.message.tps.avg").setDescription("avg of batch send message tps.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgSendBatchMsgTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.batch.send.message.num").setDescription("sum of batch send message number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getSendBatchMsgNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.batch.send.message.fail.num").setDescription("sum of batch send message fail message number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getSendBatchMsgFailNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.batch.send.message.fail.rate").setDescription("send batch message fail rate.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getSendBatchMsgFailRate(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.batch.send.message.discard.num").setDescription("sum of send batch message discard number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getSendBatchMsgDiscardNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.send.message.tps.max").setDescription("max of send message tps.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.maxSendMsgTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.send.message.tps.avg").setDescription("avg of send message tps.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgSendMsgTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.send.message.num").setDescription("sum of send message number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getSendMsgNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.send.message.fail.num").setDescription("sum of send message fail number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getSendMsgFailNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.send.message.fail.rate").setDescription("send message fail rate.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getSendMsgFailRate(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.reply.message.num").setDescription("sum of reply message number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getReplyMsgNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.reply.message.fail.num").setDescription("sum of reply message fail number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getReplyMsgFailNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.push.message.tps.max").setDescription("max of push message tps.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.maxPushMsgTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.push.message.tps.avg").setDescription("avg of push message tps.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgPushMsgTPS(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.push.message.num").setDescription("sum of http push message number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getHttpPushMsgNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.push.message.fail.num").setDescription("sum of http push message fail number.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getHttpPushFailNumSum(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.push.message.fail.rate").setDescription("http push message fail rate.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.getHttpPushMsgFailRate(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.push.latency.max").setDescription("max of http push latency.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.maxHTTPPushLatency(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.http.push.latency.avg").setDescription("avg of http push latency.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgHTTPPushLatency(), Labels.empty())).build();
        meter.longValueObserverBuilder("eventmesh.batch.message.queue.size").setDescription("size of batch message queue.").setUnit("HTTP").setUpdater(result -> result.observe((long)summaryMetrics.getBatchMsgQueueSize(), Labels.empty())).build();
        meter.longValueObserverBuilder("eventmesh.send.message.queue.size").setDescription("size of send message queue.").setUnit("HTTP").setUpdater(result -> result.observe((long)summaryMetrics.getSendMsgQueueSize(), Labels.empty())).build();
        meter.longValueObserverBuilder("eventmesh.push.message.queue.size").setDescription("size of push message queue.").setUnit("HTTP").setUpdater(result -> result.observe((long)summaryMetrics.getPushMsgQueueSize(), Labels.empty())).build();
        meter.longValueObserverBuilder("eventmesh.http.retry.queue.size").setDescription("size of http retry queue.").setUnit("HTTP").setUpdater(result -> result.observe((long)summaryMetrics.getHttpRetryQueueSize(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.batch.send.message.cost.avg").setDescription("avg of batch send message cost.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgBatchSendMsgCost(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.send.message.cost.avg").setDescription("avg of send message cost.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgSendMsgCost(), Labels.empty())).build();
        meter.doubleValueObserverBuilder("eventmesh.reply.message.cost.avg").setDescription("avg of reply message cost.").setUnit("HTTP").setUpdater(result -> result.observe((double)summaryMetrics.avgReplyMsgCost(), Labels.empty())).build();
    }

    private PrometheusHttpExporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

