/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.auth.AuthService;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)WebhookUtil.class.getName());
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String REQUEST_ORIGIN_HEADER = "WebHook-Request-Origin";
    private static final String ALLOWED_ORIGIN_HEADER = "WebHook-Allowed-Origin";
    private static final Map<String, AuthService> authServices = new ConcurrentHashMap<String, AuthService>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean obtainDeliveryAgreement(CloseableHttpClient httpClient, String targetUrl, String requestOrigin) {
        logger.info("obtain webhook delivery agreement for url: {}", (Object)targetUrl);
        HttpOptions builder = new HttpOptions(targetUrl);
        builder.addHeader(REQUEST_ORIGIN_HEADER, requestOrigin);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)builder);){
            String allowedOrigin = response.getLastHeader(ALLOWED_ORIGIN_HEADER).getValue();
            boolean bl = StringUtils.isEmpty((CharSequence)allowedOrigin) || allowedOrigin.equals("*") || allowedOrigin.equalsIgnoreCase(requestOrigin);
            return bl;
        }
        catch (Exception e) {
            logger.warn("HTTP Options Method is not supported at the Delivery Target: {}, unable to obtain the webhook delivery agreement.", (Object)targetUrl);
            return true;
        }
    }

    public static void setWebhookHeaders(HttpPost builder, String contentType, String requestOrigin, String urlAuthType) {
        builder.setHeader(CONTENT_TYPE_HEADER, contentType);
        builder.setHeader(REQUEST_ORIGIN_HEADER, requestOrigin);
        Map<String, String> authParam = WebhookUtil.getHttpAuthParam(urlAuthType);
        if (authParam != null) {
            authParam.forEach((k, v) -> builder.addHeader((Header)new BasicHeader(k, v)));
        }
    }

    private static Map<String, String> getHttpAuthParam(String authType) {
        if (StringUtils.isEmpty((CharSequence)authType)) {
            return null;
        }
        AuthService authService = WebhookUtil.getHttpAuthPlugin(authType);
        if (authService != null) {
            return authService.getAuthParams();
        }
        return null;
    }

    private static AuthService getHttpAuthPlugin(String pluginType) {
        if (authServices.containsKey(pluginType)) {
            return authServices.get(pluginType);
        }
        AuthService authService = (AuthService)EventMeshExtensionFactory.getExtension(AuthService.class, (String)pluginType);
        if (authService == null) {
            logger.error("can't load the authService plugin, please check.");
            throw new RuntimeException("doesn't load the authService plugin, please check.");
        }
        try {
            authService.init();
            authServices.put(pluginType, authService);
            return authService;
        }
        catch (Exception e) {
            logger.error("Error in initializing authService", (Throwable)e);
            return null;
        }
    }
}

