/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.RedirectInfo;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMonitor;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcp2Client {
    private static final Logger logger = LoggerFactory.getLogger(EventMeshTcp2Client.class);

    public static InetSocketAddress serverGoodby2Client(EventMeshTCPServer eventMeshTCPServer, final Session session, ClientSessionGroupMapping mapping) {
        logger.info("serverGoodby2Client client[{}]", (Object)session.getClient());
        try {
            final long startTime = System.currentTimeMillis();
            final Package msg = new Package();
            msg.setHeader(new Header(Command.SERVER_GOODBYE_REQUEST, OPStatus.SUCCESS.getCode().intValue(), "graceful normal quit from eventmesh", null));
            eventMeshTCPServer.getScheduler().submit(new Runnable(){

                @Override
                public void run() {
                    long taskExecuteTime = System.currentTimeMillis();
                    Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session);
                }
            });
            InetSocketAddress address = (InetSocketAddress)session.getContext().channel().remoteAddress();
            EventMeshTcp2Client.closeSessionIfTimeout(eventMeshTCPServer, session, mapping);
            return address;
        }
        catch (Exception e) {
            logger.error("exception occur while serverGoodby2Client", (Throwable)e);
            return null;
        }
    }

    public static InetSocketAddress goodBye2Client(EventMeshTCPServer eventMeshTCPServer, final Session session, String errMsg, int eventMeshStatus, ClientSessionGroupMapping mapping) {
        try {
            final long startTime = System.currentTimeMillis();
            final Package msg = new Package();
            msg.setHeader(new Header(Command.SERVER_GOODBYE_REQUEST, eventMeshStatus, errMsg, null));
            eventMeshTCPServer.getScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    long taskExecuteTime = System.currentTimeMillis();
                    Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session);
                }
            }, 1000L, TimeUnit.MILLISECONDS);
            EventMeshTcp2Client.closeSessionIfTimeout(eventMeshTCPServer, session, mapping);
            return session.getRemoteAddress();
        }
        catch (Exception e) {
            logger.error("exception occur while goodbye2client", (Throwable)e);
            return null;
        }
    }

    public static void goodBye2Client(final ChannelHandlerContext ctx, String errMsg, final ClientSessionGroupMapping mapping, EventMeshTcpMonitor eventMeshTcpMonitor) {
        final long startTime = System.currentTimeMillis();
        final Package pkg = new Package(new Header(Command.SERVER_GOODBYE_REQUEST, OPStatus.FAIL.getCode().intValue(), errMsg, null));
        eventMeshTcpMonitor.getTcpSummaryMetrics().getEventMesh2clientMsgNum().incrementAndGet();
        logger.info("goodBye2Client client[{}]", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
        ctx.writeAndFlush((Object)pkg).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Utils.logSucceedMessageFlow(pkg, null, startTime, startTime);
                try {
                    mapping.closeSession(ctx);
                }
                catch (Exception e) {
                    logger.warn("close session failed!", (Throwable)e);
                }
            }
        });
    }

    public static String redirectClient2NewEventMesh(EventMeshTCPServer eventMeshTCPServer, String newEventMeshIp, int port, final Session session, ClientSessionGroupMapping mapping) {
        logger.info("begin to gracefully redirect Client {}, newIPPort[{}]", (Object)session.getClient(), (Object)(newEventMeshIp + ":" + port));
        try {
            final long startTime = System.currentTimeMillis();
            final Package pkg = new Package();
            pkg.setHeader(new Header(Command.REDIRECT_TO_CLIENT, OPStatus.SUCCESS.getCode().intValue(), null, null));
            pkg.setBody((Object)new RedirectInfo(newEventMeshIp, port));
            eventMeshTCPServer.getScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    long taskExecuteTime = System.currentTimeMillis();
                    Utils.writeAndFlush(pkg, startTime, taskExecuteTime, session.getContext(), session);
                }
            }, 5000L, TimeUnit.MILLISECONDS);
            EventMeshTcp2Client.closeSessionIfTimeout(eventMeshTCPServer, session, mapping);
            return session.getRemoteAddress() + "--->" + newEventMeshIp + ":" + port;
        }
        catch (Exception e) {
            logger.error("exception occur while redirectClient2NewEventMesh", (Throwable)e);
            return null;
        }
    }

    public static void closeSessionIfTimeout(EventMeshTCPServer eventMeshTCPServer, final Session session, final ClientSessionGroupMapping mapping) {
        eventMeshTCPServer.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!session.getSessionState().equals((Object)SessionState.CLOSED)) {
                        mapping.closeSession(session.getContext());
                        logger.info("closeSessionIfTimeout success, session[{}]", (Object)session.getClient());
                    }
                }
                catch (Exception e) {
                    logger.error("close session failed", (Throwable)e);
                }
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }
}

