/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchV2ResponseBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchV2RequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchV2ResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSendMessageV2Processor
implements HttpRequestProcessor {
    public Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private EventMeshHTTPServer eventMeshHTTPServer;
    public Logger batchMessageLogger = LoggerFactory.getLogger((String)"batchMessage");

    public BatchSendMessageV2Processor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        HttpCommand responseEventMeshCommand;
        HttpCommand request = asyncContext.getRequest();
        Integer requestCode = Integer.valueOf(request.getRequestCode());
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)requestCode), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), IPUtils.getLocalAddress()});
        SendMessageBatchV2RequestHeader sendMessageBatchV2RequestHeader = (SendMessageBatchV2RequestHeader)asyncContext.getRequest().getHeader();
        String protocolType = sendMessageBatchV2RequestHeader.getProtocolType();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)asyncContext.getRequest());
        SendMessageBatchV2ResponseHeader sendMessageBatchV2ResponseHeader = SendMessageBatchV2ResponseHeader.buildHeader((Integer)requestCode, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshCluster, (String)IPUtils.getLocalAddress(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEnv, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshIDC);
        if (StringUtils.isBlank((CharSequence)event.getId()) || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isBlank((CharSequence)event.getType()) || StringUtils.isBlank((CharSequence)event.getSubject())) {
            HttpCommand responseEventMeshCommand2 = request.createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand2);
            return;
        }
        String idc = Objects.requireNonNull(event.getExtension("idc")).toString();
        String pid = Objects.requireNonNull(event.getExtension("pid")).toString();
        String sys = Objects.requireNonNull(event.getExtension("sys")).toString();
        if (StringUtils.isBlank((CharSequence)idc) || StringUtils.isBlank((CharSequence)pid) || !StringUtils.isNumeric((CharSequence)pid) || StringUtils.isBlank((CharSequence)sys)) {
            HttpCommand responseEventMeshCommand3 = request.createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand3);
            return;
        }
        final String bizNo = Objects.requireNonNull(event.getExtension("bizseqno")).toString();
        String producerGroup = Objects.requireNonNull(event.getExtension("producergroup")).toString();
        final String topic = event.getSubject();
        if (StringUtils.isBlank((CharSequence)bizNo) || StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)producerGroup) || event.getData() == null) {
            HttpCommand responseEventMeshCommand4 = request.createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand4);
            return;
        }
        String content = new String(event.getData().toBytes(), StandardCharsets.UTF_8);
        if (content.length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize) {
            this.batchMessageLogger.error("Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
            HttpCommand responseEventMeshCommand5 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)("Event size exceeds the limit: " + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize)));
            asyncContext.onComplete(responseEventMeshCommand5);
            return;
        }
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshServerSecurityEnable) {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String user = event.getExtension("username").toString();
            String pass = event.getExtension("passwd").toString();
            String subsystem = event.getExtension("sys").toString();
            try {
                Acl.doAclCheckInHttpSend(remoteAddr, user, pass, subsystem, topic, requestCode);
            }
            catch (Exception e) {
                HttpCommand responseEventMeshCommand6 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode(), (String)e.getMessage()));
                asyncContext.onComplete(responseEventMeshCommand6);
                this.aclLogger.warn("CLIENT HAS NO PERMISSION,BatchSendMessageV2Processor send failed", (Throwable)e);
                return;
            }
        }
        if (!this.eventMeshHTTPServer.getBatchRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            HttpCommand responseEventMeshCommand7 = request.createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR.getErrMsg()));
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendBatchMsgDiscard(1L);
            asyncContext.onComplete(responseEventMeshCommand7);
            return;
        }
        EventMeshProducer batchEventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        batchEventMeshProducer.getMqProducerWrapper().getMeshMQProducer().setExtFields();
        if (!batchEventMeshProducer.getStarted().get()) {
            HttpCommand responseEventMeshCommand8 = request.createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand8);
            return;
        }
        final long batchStartTime = System.currentTimeMillis();
        String ttl = String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS);
        if (StringUtils.isBlank((CharSequence)event.getExtension("ttl").toString()) && !StringUtils.isNumeric((CharSequence)event.getExtension("ttl").toString())) {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("ttl", ttl).build();
        }
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            if (this.batchMessageLogger.isDebugEnabled()) {
                this.batchMessageLogger.debug("msg2MQMsg suc, topic:{}, msg:{}", (Object)topic, (Object)event.getData());
            }
        }
        catch (Exception e) {
            this.batchMessageLogger.error("msg2MQMsg err, topic:{}, msg:{}", new Object[]{topic, event.getData(), e});
            HttpCommand responseEventMeshCommand9 = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand9);
            return;
        }
        this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordSendBatchMsg(1L);
        final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, batchEventMeshProducer, this.eventMeshHTTPServer);
        try {
            batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    long batchEndTime = System.currentTimeMillis();
                    ((BatchSendMessageV2Processor)BatchSendMessageV2Processor.this).eventMeshHTTPServer.metrics.getSummaryMetrics().recordBatchSendMsgCost(batchEndTime - batchStartTime);
                    BatchSendMessageV2Processor.this.batchMessageLogger.debug("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{bizNo, batchEndTime - batchStartTime, topic});
                }

                public void onException(OnExceptionContext context) {
                    long batchEndTime = System.currentTimeMillis();
                    BatchSendMessageV2Processor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    ((BatchSendMessageV2Processor)BatchSendMessageV2Processor.this).eventMeshHTTPServer.metrics.getSummaryMetrics().recordBatchSendMsgCost(batchEndTime - batchStartTime);
                    BatchSendMessageV2Processor.this.batchMessageLogger.error("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{bizNo, batchEndTime - batchStartTime, topic, context.getException()});
                }
            });
        }
        catch (Exception e) {
            responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_SEND_BATCHLOG_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_SEND_BATCHLOG_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(responseEventMeshCommand);
            long batchEndTime = System.currentTimeMillis();
            this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
            this.eventMeshHTTPServer.metrics.getSummaryMetrics().recordBatchSendMsgCost(batchEndTime - batchStartTime);
            this.batchMessageLogger.error("batchMessageV2|eventMesh2mq|REQ|ASYNC|bizSeqNo={}|send2MQCost={}ms|topic={}", new Object[]{bizNo, batchEndTime - batchStartTime, topic, e});
        }
        responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)sendMessageBatchV2ResponseHeader, (Body)SendMessageBatchV2ResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)EventMeshRetCode.SUCCESS.getErrMsg()));
        asyncContext.onComplete(responseEventMeshCommand);
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

