/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.push;

import com.google.common.collect.Sets;
import io.cloudevents.CloudEvent;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.WebhookPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.GrpcRetryer;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.RetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushRequest
extends RetryContext {
    private final Logger logger = LoggerFactory.getLogger(ConsumerGroupTopicConfig.class);
    protected EventMeshGrpcServer eventMeshGrpcServer;
    protected long createTime = System.currentTimeMillis();
    protected long lastPushTime = System.currentTimeMillis();
    protected EventMeshConsumer eventMeshConsumer;
    protected EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    protected GrpcRetryer grpcRetryer;
    protected Map<String, Set<AbstractPushRequest>> waitingRequests;
    protected HandleMsgContext handleMsgContext;
    protected SimpleMessage simpleMessage;
    private final AtomicBoolean complete = new AtomicBoolean(Boolean.FALSE);

    public AbstractPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractPushRequest>> waitingRequests) {
        this.eventMeshGrpcServer = handleMsgContext.getEventMeshGrpcServer();
        this.handleMsgContext = handleMsgContext;
        this.waitingRequests = waitingRequests;
        this.eventMeshConsumer = handleMsgContext.getEventMeshConsumer();
        this.eventMeshGrpcConfiguration = handleMsgContext.getEventMeshGrpcServer().getEventMeshGrpcConfiguration();
        this.grpcRetryer = handleMsgContext.getEventMeshGrpcServer().getGrpcRetryer();
        CloudEvent event = handleMsgContext.getEvent();
        this.simpleMessage = this.getSimpleMessage(event);
    }

    public abstract void tryPushRequest();

    private SimpleMessage getSimpleMessage(CloudEvent cloudEvent) {
        try {
            String protocolType = Objects.requireNonNull(cloudEvent.getExtension("protocoltype")).toString();
            ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
            ProtocolTransportObject protocolTransportObject = protocolAdaptor.fromCloudEvent(cloudEvent);
            return ((SimpleMessageWrapper)protocolTransportObject).getMessage();
        }
        catch (Exception e) {
            this.logger.error("Error in getting EventMeshMessage from CloudEvent", (Throwable)e);
            return null;
        }
    }

    private CloudEvent getCloudEvent(SimpleMessage simpleMessage) {
        try {
            String protocolType = Objects.requireNonNull(simpleMessage.getHeader().getProtocolType());
            ProtocolAdaptor protocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
            return protocolAdaptor.toCloudEvent((ProtocolTransportObject)new SimpleMessageWrapper(simpleMessage));
        }
        catch (Exception e) {
            this.logger.error("Error in getting CloudEvent from EventMeshMessage", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean retry() {
        this.tryPushRequest();
        return true;
    }

    protected void delayRetry() {
        if (this.retryTimes < 3) {
            ++this.retryTimes;
            this.delay((long)this.retryTimes * 3000L);
            this.grpcRetryer.pushRetry(this);
        } else {
            this.complete();
        }
    }

    protected boolean isComplete() {
        return this.complete.get();
    }

    private void finish() {
        AbstractContext context = this.handleMsgContext.getContext();
        Subscription.SubscriptionItem.SubscriptionMode subscriptionMode = this.handleMsgContext.getSubscriptionMode();
        CloudEvent event = this.getCloudEvent(this.simpleMessage);
        if (this.eventMeshConsumer != null && context != null && event != null) {
            try {
                this.eventMeshConsumer.updateOffset(subscriptionMode, Collections.singletonList(event), context);
            }
            catch (Exception e) {
                this.logger.error("Error in updating offset in EventMeshConsumer", (Throwable)e);
            }
        }
    }

    protected void complete() {
        this.complete.compareAndSet(Boolean.FALSE, Boolean.TRUE);
        this.finish();
    }

    protected void timeout() {
        if (!this.isComplete() && System.currentTimeMillis() - this.lastPushTime >= Long.parseLong(this.simpleMessage.getTtl())) {
            this.delayRetry();
        }
    }

    public HandleMsgContext getHandleMsgContext() {
        return this.handleMsgContext;
    }

    protected void addToWaitingMap(WebhookPushRequest request) {
        if (this.waitingRequests.containsKey(this.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(this.handleMsgContext.getConsumerGroup()).add(request);
            return;
        }
        this.waitingRequests.put(this.handleMsgContext.getConsumerGroup(), Sets.newConcurrentHashSet());
        this.waitingRequests.get(this.handleMsgContext.getConsumerGroup()).add(request);
    }

    protected void removeWaitingMap(WebhookPushRequest request) {
        if (this.waitingRequests.containsKey(this.handleMsgContext.getConsumerGroup())) {
            this.waitingRequests.get(this.handleMsgContext.getConsumerGroup()).remove(request);
        }
    }
}

