/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeStreamProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final GrpcType grpcType = GrpcType.STREAM;

    public SubscribeStreamProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void process(Subscription subscription, EventEmitter<SimpleMessage> emitter) throws Exception {
        RequestHeader header = subscription.getHeader();
        if (!ServiceUtils.validateHeader(header)) {
            ServiceUtils.sendStreamRespAndDone(header, StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateSubscription(this.grpcType, subscription)) {
            ServiceUtils.sendStreamRespAndDone(header, StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        try {
            this.doAclCheck(subscription);
        }
        catch (AclException e) {
            this.aclLogger.warn("CLIENT HAS NO PERMISSION to Subscribe. failed", (Throwable)e);
            ServiceUtils.sendStreamRespAndDone(header, StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        String consumerGroup = subscription.getConsumerGroup();
        List subscriptionItems = subscription.getSubscriptionItemsList();
        LinkedList<ConsumerGroupClient> newClients = new LinkedList<ConsumerGroupClient>();
        for (Subscription.SubscriptionItem item : subscriptionItems) {
            ConsumerGroupClient newClient = ConsumerGroupClient.builder().env(header.getEnv()).idc(header.getIdc()).sys(header.getSys()).ip(header.getIp()).pid(header.getPid()).consumerGroup(consumerGroup).topic(item.getTopic()).subscriptionMode(item.getMode()).grpcType(this.grpcType).eventEmitter(emitter).lastUpTime(new Date()).build();
            newClients.add(newClient);
        }
        for (ConsumerGroupClient newClient : newClients) {
            consumerManager.registerClient(newClient);
        }
        EventMeshConsumer eventMeshConsumer = consumerManager.getEventMeshConsumer(consumerGroup);
        boolean requireRestart = false;
        for (ConsumerGroupClient newClient : newClients) {
            if (!eventMeshConsumer.registerClient(newClient)) continue;
            requireRestart = true;
        }
        if (requireRestart) {
            this.logger.info("ConsumerGroup {} topic info changed, restart EventMesh Consumer", (Object)consumerGroup);
            consumerManager.restartEventMeshConsumer(consumerGroup);
        } else {
            this.logger.warn("EventMesh consumer [{}] didn't restart.", (Object)consumerGroup);
        }
        ServiceUtils.sendStreamResp(header, StatusCode.SUCCESS, "subscribe success", emitter);
    }

    private void doAclCheck(Subscription subscription) throws AclException {
        RequestHeader header = subscription.getHeader();
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshServerSecurityEnable) {
            String remoteAdd = header.getIp();
            String user = header.getUsername();
            String pass = header.getPassword();
            String subsystem = header.getSys();
            for (Subscription.SubscriptionItem item : subscription.getSubscriptionItemsList()) {
                Acl.doAclCheckInHttpReceive(remoteAdd, user, pass, subsystem, item.getTopic(), RequestCode.SUBSCRIBE.getRequestCode());
            }
        }
    }
}

