/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.SendMessageContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.MessageHandler;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshConsumer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String consumerGroup;
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private final MQConsumerWrapper persistentMqConsumer;
    private final MQConsumerWrapper broadcastMqConsumer;
    private final MessageHandler messageHandler;
    private ServiceState serviceState;
    private final Map<String, ConsumerGroupTopicConfig> consumerGroupTopicConfig = new ConcurrentHashMap<String, ConsumerGroupTopicConfig>();

    public EventMeshConsumer(EventMeshGrpcServer eventMeshGrpcServer, String consumerGroup) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.eventMeshGrpcConfiguration = eventMeshGrpcServer.getEventMeshGrpcConfiguration();
        this.consumerGroup = consumerGroup;
        this.messageHandler = new MessageHandler(consumerGroup, eventMeshGrpcServer.getPushMsgExecutor());
        this.persistentMqConsumer = new MQConsumerWrapper(this.eventMeshGrpcConfiguration.eventMeshConnectorPluginType);
        this.broadcastMqConsumer = new MQConsumerWrapper(this.eventMeshGrpcConfiguration.eventMeshConnectorPluginType);
    }

    public synchronized boolean registerClient(ConsumerGroupClient client) {
        boolean requireRestart = false;
        GrpcType grpcType = client.getGrpcType();
        String topic = client.getTopic();
        Subscription.SubscriptionItem.SubscriptionMode subscriptionMode = client.getSubscriptionMode();
        ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(topic);
        if (topicConfig == null) {
            topicConfig = ConsumerGroupTopicConfig.buildTopicConfig(this.consumerGroup, topic, subscriptionMode, grpcType);
            this.consumerGroupTopicConfig.put(topic, topicConfig);
            requireRestart = true;
        }
        topicConfig.registerClient(client);
        return requireRestart;
    }

    public synchronized boolean deregisterClient(ConsumerGroupClient client) {
        boolean requireRestart = false;
        String topic = client.getTopic();
        ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(topic);
        if (topicConfig != null) {
            topicConfig.deregisterClient(client);
            if (topicConfig.getSize() == 0) {
                this.consumerGroupTopicConfig.remove(topic);
                requireRestart = true;
            }
        }
        return requireRestart;
    }

    public synchronized void init() throws Exception {
        if (this.consumerGroupTopicConfig.size() == 0) {
            return;
        }
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "false");
        keyValue.put("consumerGroup", this.consumerGroup);
        keyValue.put("eventMeshIDC", this.eventMeshGrpcConfiguration.eventMeshIDC);
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroup, this.eventMeshGrpcConfiguration.eventMeshCluster));
        this.persistentMqConsumer.init(keyValue);
        EventListener clusterEventListner = this.createEventListener(Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING);
        this.persistentMqConsumer.registerEventListener(clusterEventListner);
        Properties broadcastKeyValue = new Properties();
        broadcastKeyValue.put("isBroadcast", "true");
        broadcastKeyValue.put("consumerGroup", this.consumerGroup);
        broadcastKeyValue.put("eventMeshIDC", this.eventMeshGrpcConfiguration.eventMeshIDC);
        broadcastKeyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroup, this.eventMeshGrpcConfiguration.eventMeshCluster));
        this.broadcastMqConsumer.init(broadcastKeyValue);
        EventListener broadcastEventListner = this.createEventListener(Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING);
        this.broadcastMqConsumer.registerEventListener(broadcastEventListner);
        this.serviceState = ServiceState.INITED;
        this.logger.info("EventMeshConsumer [{}] initialized.............", (Object)this.consumerGroup);
    }

    public synchronized void start() throws Exception {
        if (this.consumerGroupTopicConfig.size() == 0) {
            return;
        }
        for (Map.Entry<String, ConsumerGroupTopicConfig> entry : this.consumerGroupTopicConfig.entrySet()) {
            this.subscribe(entry.getKey(), entry.getValue().getSubscriptionMode());
        }
        this.persistentMqConsumer.start();
        this.broadcastMqConsumer.start();
        this.serviceState = ServiceState.RUNNING;
        this.logger.info("EventMeshConsumer [{}] started..........", (Object)this.consumerGroup);
    }

    public synchronized void shutdown() throws Exception {
        this.persistentMqConsumer.shutdown();
        this.broadcastMqConsumer.shutdown();
        this.serviceState = ServiceState.STOPED;
        this.logger.info("EventMeshConsumer [{}] shutdown.........", (Object)this.consumerGroup);
    }

    public ServiceState getStatus() {
        return this.serviceState;
    }

    public void subscribe(String topic, Subscription.SubscriptionItem.SubscriptionMode subscriptionMode) throws Exception {
        if (Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING.equals((Object)subscriptionMode)) {
            this.persistentMqConsumer.subscribe(topic);
        } else if (Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING.equals((Object)subscriptionMode)) {
            this.broadcastMqConsumer.subscribe(topic);
        } else {
            this.logger.error("Subscribe Failed. Incorrect Subscription Mode");
            throw new Exception("Subscribe Failed. Incorrect Subscription Mode");
        }
    }

    public void unsubscribe(Subscription.SubscriptionItem subscriptionItem) throws Exception {
        Subscription.SubscriptionItem.SubscriptionMode mode = subscriptionItem.getMode();
        String topic = subscriptionItem.getTopic();
        if (Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING.equals((Object)mode)) {
            this.persistentMqConsumer.unsubscribe(topic);
        } else if (Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING.equals((Object)mode)) {
            this.broadcastMqConsumer.unsubscribe(topic);
        } else {
            this.logger.error("Unsubscribe Failed. Incorrect Subscription Mode");
            throw new Exception("Unsubscribe Failed. Incorrect Subscription Mode");
        }
    }

    public void updateOffset(Subscription.SubscriptionItem.SubscriptionMode subscriptionMode, List<CloudEvent> events, AbstractContext context) throws Exception {
        if (Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING.equals((Object)subscriptionMode)) {
            this.persistentMqConsumer.updateOffset(events, context);
        } else if (Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING.equals((Object)subscriptionMode)) {
            this.broadcastMqConsumer.updateOffset(events, context);
        } else {
            this.logger.error("Subscribe Failed. Incorrect Subscription Mode");
            throw new Exception("Subscribe Failed. Incorrect Subscription Mode");
        }
    }

    private EventListener createEventListener(Subscription.SubscriptionItem.SubscriptionMode subscriptionMode) {
        return (event, context) -> {
            String strUniqueId;
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
            String topic = event.getSubject();
            Object bizSeqNo = event.getExtension("searchkeys");
            String strBizSeqNo = bizSeqNo == null ? "" : bizSeqNo.toString();
            Object uniqueId = event.getExtension("rmbuniqid");
            String string = strUniqueId = uniqueId == null ? "" : uniqueId.toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("message|mq2eventMesh|topic={}|msg={}", (Object)topic, (Object)event);
            } else {
                this.logger.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
            }
            EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
            ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(topic);
            if (topicConfig != null) {
                GrpcType grpcType = topicConfig.getGrpcType();
                HandleMsgContext handleMsgContext = new HandleMsgContext(this.consumerGroup, event, subscriptionMode, grpcType, eventMeshAsyncConsumeContext.getAbstractContext(), this.eventMeshGrpcServer, this, topicConfig);
                if (this.messageHandler.handle(handleMsgContext)) {
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                    return;
                }
                try {
                    Thread.sleep(5000L);
                    this.sendMessageBack(this.consumerGroup, event, strUniqueId, strBizSeqNo);
                }
                catch (Exception exception) {}
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("no active consumer for topic={}|msg={}", (Object)topic, (Object)event);
            }
            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
        };
    }

    public void sendMessageBack(final String consumerGroup, CloudEvent event, final String uniqueId, final String bizSeqNo) throws Exception {
        EventMeshProducer producer = this.eventMeshGrpcServer.getProducerManager().getEventMeshProducer(consumerGroup);
        if (producer == null) {
            this.logger.warn("consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", new Object[]{consumerGroup, bizSeqNo, uniqueId});
            return;
        }
        SendMessageContext sendMessageBackContext = new SendMessageContext(bizSeqNo, event, producer, this.eventMeshGrpcServer);
        producer.send(sendMessageBackContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                EventMeshConsumer.this.logger.warn("consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", new Object[]{consumerGroup, bizSeqNo, uniqueId});
            }
        });
    }
}

