/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, List<ConsumerGroupClient>> clientTable = new ConcurrentHashMap<String, List<ConsumerGroupClient>>();
    private final Map<String, EventMeshConsumer> consumerTable = new ConcurrentHashMap<String, EventMeshConsumer>();

    public ConsumerManager(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void init() throws Exception {
        this.logger.info("Grpc ConsumerManager initialized......");
    }

    public void start() throws Exception {
        this.startClientCheck();
        this.logger.info("Grpc ConsumerManager started......");
    }

    public void shutdown() throws Exception {
        for (EventMeshConsumer consumer : this.consumerTable.values()) {
            consumer.shutdown();
        }
        this.scheduledExecutorService.shutdown();
        this.logger.info("Grpc ConsumerManager shutdown......");
    }

    public EventMeshConsumer getEventMeshConsumer(String consumerGroup) {
        EventMeshConsumer consumer = this.consumerTable.get(consumerGroup);
        if (consumer == null) {
            consumer = new EventMeshConsumer(this.eventMeshGrpcServer, consumerGroup);
            this.consumerTable.put(consumerGroup, consumer);
        }
        return consumer;
    }

    public synchronized void registerClient(ConsumerGroupClient newClient) {
        String consumerGroup = newClient.getConsumerGroup();
        String topic = newClient.getTopic();
        GrpcType grpcType = newClient.getGrpcType();
        String url = newClient.getUrl();
        String ip = newClient.getIp();
        String pid = newClient.getPid();
        Subscription.SubscriptionItem.SubscriptionMode subscriptionMode = newClient.getSubscriptionMode();
        List<ConsumerGroupClient> localClients = this.clientTable.get(consumerGroup);
        if (localClients == null) {
            localClients = new ArrayList<ConsumerGroupClient>();
            localClients.add(newClient);
            this.clientTable.put(consumerGroup, localClients);
        } else {
            boolean isContains = false;
            for (ConsumerGroupClient localClient : localClients) {
                if (GrpcType.WEBHOOK.equals((Object)grpcType) && StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)topic) && StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)url) && localClient.getSubscriptionMode().equals((Object)subscriptionMode)) {
                    isContains = true;
                    localClient.setUrl(newClient.getUrl());
                    localClient.setLastUpTime(newClient.getLastUpTime());
                    break;
                }
                if (!GrpcType.STREAM.equals((Object)grpcType) || !StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)topic) || !StringUtils.equals((CharSequence)localClient.getIp(), (CharSequence)ip) || !StringUtils.equals((CharSequence)localClient.getPid(), (CharSequence)pid) || !localClient.getSubscriptionMode().equals((Object)subscriptionMode)) continue;
                isContains = true;
                localClient.setEventEmitter(newClient.getEventEmitter());
                localClient.setLastUpTime(newClient.getLastUpTime());
                break;
            }
            if (!isContains) {
                localClients.add(newClient);
            }
        }
    }

    public void updateClientTime(ConsumerGroupClient client) {
        String consumerGroup = client.getConsumerGroup();
        List<ConsumerGroupClient> localClients = this.clientTable.get(consumerGroup);
        if (CollectionUtils.isEmpty(localClients)) {
            return;
        }
        for (ConsumerGroupClient localClient : localClients) {
            if (!StringUtils.equals((CharSequence)localClient.getIp(), (CharSequence)client.getIp()) || !StringUtils.equals((CharSequence)localClient.getPid(), (CharSequence)client.getPid()) || !StringUtils.equals((CharSequence)localClient.getSys(), (CharSequence)client.getSys()) || !StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)client.getTopic())) continue;
            localClient.setLastUpTime(new Date());
            break;
        }
    }

    public synchronized void deregisterClient(ConsumerGroupClient client) {
        String consumerGroup = client.getConsumerGroup();
        List<ConsumerGroupClient> localClients = this.clientTable.get(consumerGroup);
        if (CollectionUtils.isEmpty(localClients)) {
            return;
        }
        Iterator<ConsumerGroupClient> iterator = localClients.iterator();
        while (iterator.hasNext()) {
            ConsumerGroupClient localClient = iterator.next();
            if (!StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)client.getTopic()) || !localClient.getSubscriptionMode().equals((Object)client.getSubscriptionMode())) continue;
            this.closeEventStream(localClient);
            iterator.remove();
        }
        if (localClients.size() == 0) {
            this.clientTable.remove(consumerGroup);
        }
    }

    private void closeEventStream(ConsumerGroupClient client) {
        if (client.getEventEmitter() != null) {
            client.getEventEmitter().onCompleted();
        }
    }

    public synchronized void restartEventMeshConsumer(String consumerGroup) throws Exception {
        EventMeshConsumer eventMeshConsumer = this.consumerTable.get(consumerGroup);
        if (eventMeshConsumer == null) {
            return;
        }
        if (ServiceState.RUNNING.equals((Object)eventMeshConsumer.getStatus())) {
            eventMeshConsumer.shutdown();
        }
        eventMeshConsumer.init();
        eventMeshConsumer.start();
        if (!ServiceState.RUNNING.equals((Object)eventMeshConsumer.getStatus())) {
            this.consumerTable.remove(consumerGroup);
        }
    }

    private void startClientCheck() {
        int clientTimeout = this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().eventMeshSessionExpiredInMills;
        if (clientTimeout > 0) {
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                this.logger.info("grpc client info check");
                LinkedList<ConsumerGroupClient> clientList = new LinkedList<ConsumerGroupClient>();
                for (List<ConsumerGroupClient> clients : this.clientTable.values()) {
                    clientList.addAll(clients);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("total number of ConsumerGroupClients: {}", (Object)clientList.size());
                }
                if (clientList.isEmpty()) {
                    return;
                }
                HashSet<String> consumerGroupRestart = new HashSet<String>();
                for (ConsumerGroupClient client : clientList) {
                    if (System.currentTimeMillis() - client.getLastUpTime().getTime() <= (long)clientTimeout) continue;
                    this.logger.warn("client {} lastUpdate time {} over three heartbeat cycles. Removing it", (Object)JsonUtils.serialize((Object)client), (Object)client.getLastUpTime());
                    String consumerGroup = client.getConsumerGroup();
                    EventMeshConsumer consumer = this.getEventMeshConsumer(consumerGroup);
                    this.deregisterClient(client);
                    if (!consumer.deregisterClient(client)) continue;
                    consumerGroupRestart.add(consumerGroup);
                }
                for (String consumerGroup : consumerGroupRestart) {
                    try {
                        this.restartEventMeshConsumer(consumerGroup);
                    }
                    catch (Exception e) {
                        this.logger.error("Error in restarting EventMeshConsumer [{}]", (Object)consumerGroup, (Object)e);
                    }
                }
            }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        }
    }
}

