/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshHTTPConfiguration
extends CommonConfiguration {
    public static Logger logger = LoggerFactory.getLogger(EventMeshHTTPConfiguration.class);
    public int httpServerPort = 10105;
    public boolean eventMeshServerBatchMsgBatchEnabled = Boolean.TRUE;
    public int eventMeshServerBatchMsgThreadNum = 10;
    public int eventMeshServerSendMsgThreadNum = 8;
    public int eventMeshServerPushMsgThreadNum = 8;
    public int eventMeshServerReplyMsgThreadNum = 8;
    public int eventMeshServerClientManageThreadNum = 4;
    public int eventMeshServerRegistryThreadNum = 10;
    public int eventMeshServerAdminThreadNum = 2;
    public int eventMeshServerRetryThreadNum = 2;
    public int eventMeshServerPullRegistryInterval = 30000;
    public int eventMeshServerAsyncAccumulationThreshold = 1000;
    public int eventMeshServerRetryBlockQSize = 10000;
    public int eventMeshServerBatchBlockQSize = 1000;
    public int eventMeshServerSendMsgBlockQSize = 1000;
    public int eventMeshServerPushMsgBlockQSize = 1000;
    public int eventMeshServerClientManageBlockQSize = 1000;
    public int eventMeshServerBusyCheckInterval = 1000;
    public boolean eventMeshServerConsumerEnabled = false;
    public boolean eventMeshServerUseTls = false;
    public int eventMeshHttpMsgReqNumPerSecond = 15000;
    public int eventMeshBatchMsgRequestNumPerSecond = 20000;
    public int eventMeshEventSize = 1000;
    public int eventMeshEventBatchSize = 10;
    public List<IPAddress> eventMeshIpv4BlackList = Collections.emptyList();
    public List<IPAddress> eventMeshIpv6BlackList = Collections.emptyList();

    public EventMeshHTTPConfiguration(ConfigurationWrapper configurationWrapper) {
        super(configurationWrapper);
    }

    public void init() {
        super.init();
        if (this.configurationWrapper != null) {
            String ipv6BlackList;
            String ipv4BlackList;
            String eventBatchSize;
            String eventSize;
            String eventMeshHttpMsgReqNumPerSecondStr;
            String eventMeshServerUseTlsStr;
            String eventMeshServerRetryThreadNumStr;
            String eventMeshServerConsumerEnabledStr;
            String eventMeshServerBusyCheckIntervalStr;
            String eventMeshServerClientManageBlockQSizeStr;
            String eventMeshServerPushMsgBlockQSizeStr;
            String eventMeshServerSendMsgBlockQSizeStr;
            String eventMeshServerBatchBlockQSizeStr;
            String eventMeshServerRetryBlockQSizeStr;
            String eventMeshServerAdminThreadNumStr;
            String eventMeshServerPullRegistryIntervalStr;
            String eventMeshServerClientManageThreadNumStr;
            String eventMeshServerRegistryThreadNumStr;
            String eventMeshServerPushMsgThreadNumStr;
            String eventMeshServerReplyMsgThreadNumStr;
            String eventMeshServerSendMsgThreadNumStr;
            String eventMeshServerAsyncAccumulationThresholdStr;
            String eventMeshServerBatchMsgBatchEnableStr;
            String eventMeshServerBatchMsgReqNumPerSecondStr;
            String httpServerPortStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SERVER_HTTP_PORT);
            Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)httpServerPortStr) && StringUtils.isNumeric((CharSequence)httpServerPortStr) ? 1 : 0) != 0, (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_SERVER_HTTP_PORT));
            this.httpServerPort = Integer.parseInt(StringUtils.deleteWhitespace((String)httpServerPortStr));
            String eventMeshServerBatchMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_THREAD_NUM);
            if (StringUtils.isNotEmpty((CharSequence)eventMeshServerBatchMsgThreadNumStr) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchMsgThreadNumStr)) {
                this.eventMeshServerBatchMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerBatchMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBatchMsgReqNumPerSecondStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_REQ_NUM_PER_SECOND))) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchMsgReqNumPerSecondStr)) {
                this.eventMeshBatchMsgRequestNumPerSecond = Integer.parseInt(eventMeshServerBatchMsgReqNumPerSecondStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(eventMeshServerBatchMsgBatchEnableStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_BATCHMSG_BATCH_ENABLED)))) {
                this.eventMeshServerBatchMsgBatchEnabled = Boolean.parseBoolean(eventMeshServerBatchMsgBatchEnableStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerAsyncAccumulationThresholdStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_ASYNC_ACCUMULATION_THRESHOLD))) && StringUtils.isNumeric((CharSequence)eventMeshServerAsyncAccumulationThresholdStr)) {
                this.eventMeshServerAsyncAccumulationThreshold = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerAsyncAccumulationThresholdStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerSendMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_SENDMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerSendMsgThreadNumStr)) {
                this.eventMeshServerSendMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerSendMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerReplyMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_REPLYMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerReplyMsgThreadNumStr)) {
                this.eventMeshServerReplyMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerReplyMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPushMsgThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_PUSHMSG_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerPushMsgThreadNumStr)) {
                this.eventMeshServerPushMsgThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerPushMsgThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRegistryThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_REGISTRY_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerRegistryThreadNumStr)) {
                this.eventMeshServerRegistryThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerRegistryThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerClientManageThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_CLIENTMANAGE_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerClientManageThreadNumStr)) {
                this.eventMeshServerClientManageThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerClientManageThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPullRegistryIntervalStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_PULL_REGISTRY_INTERVAL))) && StringUtils.isNumeric((CharSequence)eventMeshServerPullRegistryIntervalStr)) {
                this.eventMeshServerPullRegistryInterval = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerPullRegistryIntervalStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerAdminThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_ADMIN_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerAdminThreadNumStr)) {
                this.eventMeshServerAdminThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerAdminThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRetryBlockQSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_RETRY_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerRetryBlockQSizeStr)) {
                this.eventMeshServerRetryBlockQSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerRetryBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBatchBlockQSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_BATCHMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerBatchBlockQSizeStr)) {
                this.eventMeshServerBatchBlockQSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerBatchBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerSendMsgBlockQSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SENDMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerSendMsgBlockQSizeStr)) {
                this.eventMeshServerSendMsgBlockQSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerSendMsgBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerPushMsgBlockQSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_PUSHMSG_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerPushMsgBlockQSizeStr)) {
                this.eventMeshServerPushMsgBlockQSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerPushMsgBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerClientManageBlockQSizeStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_CLIENTM_BLOCKQ_SIZE))) && StringUtils.isNumeric((CharSequence)eventMeshServerClientManageBlockQSizeStr)) {
                this.eventMeshServerClientManageBlockQSize = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerClientManageBlockQSizeStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerBusyCheckIntervalStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_BUSY_CHECK_INTERVAL))) && StringUtils.isNumeric((CharSequence)eventMeshServerBusyCheckIntervalStr)) {
                this.eventMeshServerBusyCheckInterval = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerBusyCheckIntervalStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerConsumerEnabledStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_CONSUMER_ENABLED)))) {
                this.eventMeshServerConsumerEnabled = Boolean.parseBoolean(StringUtils.deleteWhitespace((String)eventMeshServerConsumerEnabledStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerRetryThreadNumStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_RETRY_THREAD_NUM))) && StringUtils.isNumeric((CharSequence)eventMeshServerRetryThreadNumStr)) {
                this.eventMeshServerRetryThreadNum = Integer.parseInt(StringUtils.deleteWhitespace((String)eventMeshServerRetryThreadNumStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshServerUseTlsStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_HTTPS_ENABLED)))) {
                this.eventMeshServerUseTls = Boolean.parseBoolean(StringUtils.deleteWhitespace((String)eventMeshServerUseTlsStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventMeshHttpMsgReqNumPerSecondStr = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECOND))) && StringUtils.isNumeric((CharSequence)eventMeshHttpMsgReqNumPerSecondStr)) {
                this.eventMeshHttpMsgReqNumPerSecond = Integer.parseInt(eventMeshHttpMsgReqNumPerSecondStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventSize = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SERVER_EVENTSIZE))) && StringUtils.isNumeric((CharSequence)eventSize)) {
                this.eventMeshEventSize = Integer.parseInt(eventSize);
            }
            if (StringUtils.isNotEmpty((CharSequence)(eventBatchSize = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SERVER_EVENT_BATCHSIZE))) && StringUtils.isNumeric((CharSequence)eventBatchSize)) {
                this.eventMeshEventBatchSize = Integer.parseInt(eventBatchSize);
            }
            if (StringUtils.isNotEmpty((CharSequence)(ipv4BlackList = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SERVER_IPV4_BLACK_LIST)))) {
                this.eventMeshIpv4BlackList = EventMeshHTTPConfiguration.getBlacklist(ipv4BlackList);
            }
            if (StringUtils.isNotEmpty((CharSequence)(ipv6BlackList = this.configurationWrapper.getProp(ConfKeys.KEY_EVENTMESH_SERVER_IPV6_BLACK_LIST)))) {
                this.eventMeshIpv6BlackList = EventMeshHTTPConfiguration.getBlacklist(ipv6BlackList);
            }
        }
    }

    private static List<IPAddress> getBlacklist(String cidrs) {
        List cidrList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)cidrs);
        ArrayList ipAddresses = Lists.newArrayList();
        for (String cidr : cidrList) {
            try {
                ipAddresses.add(new IPAddressString(cidr).toAddress());
            }
            catch (Exception e) {
                logger.warn("Invalid cidr={}", (Object)cidr, (Object)e);
            }
        }
        return ipAddresses;
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_SERVER_HTTP_PORT = "eventMesh.server.http.port";
        public static String KEYS_EVENTMESH_BATCHMSG_THREAD_NUM = "eventMesh.server.batchmsg.threads.num";
        public static String KEYS_EVENTMESH_BATCHMSG_REQ_NUM_PER_SECOND = "eventMesh.server.batchmsg.reqNumPerSecond";
        public static String KEYS_EVENTMESH_BATCHMSG_BATCH_ENABLED = "eventMesh.server.batchmsg.batch.enabled";
        public static String KEYS_EVENTMESH_ASYNC_ACCUMULATION_THRESHOLD = "eventMesh.server.async.accumulation.threshold";
        public static String KEY_EVENTMESH_BUSY_CHECK_INTERVAL = "eventMesh.server.busy.check.interval";
        public static String KEYS_EVENTMESH_SENDMSG_THREAD_NUM = "eventMesh.server.sendmsg.threads.num";
        public static String KEYS_EVENTMESH_REPLYMSG_THREAD_NUM = "eventMesh.server.replymsg.threads.num";
        public static String KEYS_EVENTMESH_PUSHMSG_THREAD_NUM = "eventMesh.server.pushmsg.threads.num";
        public static String KEYS_EVENTMESH_REGISTRY_THREAD_NUM = "eventMesh.server.registry.threads.num";
        public static String KEYS_EVENTMESH_CLIENTMANAGE_THREAD_NUM = "eventMesh.server.clientmanage.threads.num";
        public static String KEYS_EVENTMESH_ADMIN_THREAD_NUM = "eventMesh.server.admin.threads.num";
        public static String KEY_EVENTMESH_RETRY_THREAD_NUM = "eventMesh.server.retry.threads.num";
        public static String KEYS_EVENTMESH_PULL_REGISTRY_INTERVAL = "eventMesh.server.pull.registry.interval";
        public static String KEY_EVENTMESH_RETRY_BLOCKQ_SIZE = "eventMesh.server.retry.blockQ.size";
        public static String KEY_EVENTMESH_BATCHMSG_BLOCKQ_SIZE = "eventMesh.server.batchmsg.blockQ.size";
        public static String KEY_EVENTMESH_SENDMSG_BLOCKQ_SIZE = "eventMesh.server.sendmsg.blockQ.size";
        public static String KEY_EVENTMESH_PUSHMSG_BLOCKQ_SIZE = "eventMesh.server.pushmsg.blockQ.size";
        public static String KEY_EVENTMESH_CLIENTM_BLOCKQ_SIZE = "eventMesh.server.clientM.blockQ.size";
        public static String KEY_EVENTMESH_CONSUMER_ENABLED = "eventMesh.server.consumer.enabled";
        public static String KEY_EVENTMESH_HTTPS_ENABLED = "eventMesh.server.useTls.enabled";
        public static String KEY_EVENTMESH_SERVER_MSG_REQ_NUM_PER_SECOND = "eventMesh.server.http.msgReqnumPerSecond";
        public static String KEY_EVENTMESH_SERVER_EVENTSIZE = "eventMesh.server.maxEventSize";
        public static String KEY_EVENTMESH_SERVER_EVENT_BATCHSIZE = "eventMesh.server.maxEventBatchSize";
        public static String KEY_EVENTMESH_SERVER_IPV4_BLACK_LIST = "eventMesh.server.blacklist.ipv4";
        public static String KEY_EVENTMESH_SERVER_IPV6_BLACK_LIST = "eventMesh.server.blacklist.ipv6";

        ConfKeys() {
        }
    }
}

