/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.io.File;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshStartup {
    public static Logger logger = LoggerFactory.getLogger(EventMeshStartup.class);

    public static void main(String[] args) throws Exception {
        try {
            ConfigurationWrapper configurationWrapper = new ConfigurationWrapper(EventMeshConstants.EVENTMESH_CONF_HOME + File.separator + "eventmesh.properties", false);
            EventMeshHTTPConfiguration eventMeshHttpConfiguration = new EventMeshHTTPConfiguration(configurationWrapper);
            eventMeshHttpConfiguration.init();
            EventMeshTCPConfiguration eventMeshTCPConfiguration = new EventMeshTCPConfiguration(configurationWrapper);
            eventMeshTCPConfiguration.init();
            EventMeshGrpcConfiguration eventMeshGrpcConfiguration = new EventMeshGrpcConfiguration(configurationWrapper);
            eventMeshGrpcConfiguration.init();
            EventMeshServer server = new EventMeshServer(eventMeshHttpConfiguration, eventMeshTCPConfiguration, eventMeshGrpcConfiguration);
            server.init();
            server.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    logger.info("eventMesh shutting down hook begin...");
                    long start = System.currentTimeMillis();
                    server.shutdown();
                    long end = System.currentTimeMillis();
                    logger.info("eventMesh shutdown cost {}ms", (Object)(end - start));
                }
                catch (Exception e) {
                    logger.error("exception when shutdown...", (Throwable)e);
                }
            }));
        }
        catch (Throwable e) {
            logger.error("EventMesh start fail.", e);
            e.printStackTrace();
        }
    }
}

