/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.connector.ConnectorResource;
import org.apache.eventmesh.runtime.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshServer {
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    public EventMeshHTTPServer eventMeshHTTPServer;
    private EventMeshTCPServer eventMeshTCPServer;
    private EventMeshGrpcServer eventMeshGrpcServer;
    private EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private Acl acl;
    private Registry registry;
    private ConnectorResource connectorResource;
    private ServiceState serviceState;

    public EventMeshServer(EventMeshHTTPConfiguration eventMeshHttpConfiguration, EventMeshTCPConfiguration eventMeshTCPConfiguration, EventMeshGrpcConfiguration eventMeshGrpcConfiguration) {
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
        this.eventMeshGrpcConfiguration = eventMeshGrpcConfiguration;
        this.acl = new Acl();
        this.registry = new Registry();
        this.connectorResource = new ConnectorResource();
    }

    public void init() throws Exception {
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerSecurityEnable) {
            this.acl.init(this.eventMeshHttpConfiguration.eventMeshSecurityPluginType);
        }
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled && this.eventMeshTCPConfiguration.eventMeshServerRegistryEnable) {
            this.registry.init(this.eventMeshTCPConfiguration.eventMeshRegistryPluginType);
        }
        this.connectorResource.init(this.eventMeshHttpConfiguration.eventMeshConnectorPluginType);
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer = new EventMeshGrpcServer(this.eventMeshGrpcConfiguration);
            this.eventMeshGrpcServer.init();
        }
        this.eventMeshHTTPServer = new EventMeshHTTPServer(this, this.eventMeshHttpConfiguration);
        this.eventMeshHTTPServer.init();
        this.eventMeshTCPServer = new EventMeshTCPServer(this, this.eventMeshTCPConfiguration, this.registry);
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.init();
        }
        String eventStore = System.getProperty("eventstore", System.getenv("EVENT_STORE"));
        this.logger.info("eventStore : {}", (Object)eventStore);
        this.serviceState = ServiceState.INITED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void start() throws Exception {
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerSecurityEnable) {
            this.acl.start();
        }
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled && this.eventMeshTCPConfiguration.eventMeshServerRegistryEnable) {
            this.registry.start();
        }
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.start();
        }
        this.eventMeshHTTPServer.start();
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.start();
        }
        this.serviceState = ServiceState.RUNNING;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public void shutdown() throws Exception {
        this.serviceState = ServiceState.STOPING;
        this.logger.info("server state:{}", (Object)this.serviceState);
        this.eventMeshHTTPServer.shutdown();
        if (this.eventMeshTCPConfiguration != null && this.eventMeshTCPConfiguration.eventMeshTcpServerEnabled) {
            this.eventMeshTCPServer.shutdown();
            if (this.eventMeshTCPConfiguration.eventMeshServerRegistryEnable) {
                this.registry.shutdown();
            }
        }
        this.connectorResource.release();
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.shutdown();
        }
        if (this.eventMeshHttpConfiguration != null && this.eventMeshHttpConfiguration.eventMeshServerSecurityEnable) {
            this.acl.shutdown();
        }
        this.serviceState = ServiceState.STOPED;
        this.logger.info("server state:{}", (Object)this.serviceState);
    }

    public EventMeshGrpcServer getEventMeshGrpcServer() {
        return this.eventMeshGrpcServer;
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }
}

