/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.util.concurrent.RateLimiter;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.retry.GrpcRetryer;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ConsumerService;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.HeartbeatService;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ProducerService;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private Server server;
    private ProducerManager producerManager;
    private ConsumerManager consumerManager;
    private GrpcRetryer grpcRetryer;
    private ThreadPoolExecutor sendMsgExecutor;
    private ThreadPoolExecutor replyMsgExecutor;
    private ThreadPoolExecutor clientMgmtExecutor;
    private ThreadPoolExecutor pushMsgExecutor;
    private List<CloseableHttpClient> httpClientPool;
    private RateLimiter msgRateLimiter;

    public EventMeshGrpcServer(EventMeshGrpcConfiguration eventMeshGrpcConfiguration) {
        this.eventMeshGrpcConfiguration = eventMeshGrpcConfiguration;
    }

    public void init() throws Exception {
        this.logger.info("==================EventMeshGRPCServer Initializing==================");
        this.initThreadPool();
        this.initHttpClientPool();
        this.msgRateLimiter = RateLimiter.create((double)this.eventMeshGrpcConfiguration.eventMeshMsgReqNumPerSecond);
        this.producerManager = new ProducerManager(this);
        this.producerManager.init();
        this.consumerManager = new ConsumerManager(this);
        this.consumerManager.init();
        this.grpcRetryer = new GrpcRetryer(this);
        this.grpcRetryer.init();
        int serverPort = this.eventMeshGrpcConfiguration.grpcServerPort;
        this.server = ServerBuilder.forPort((int)serverPort).addService((BindableService)new ProducerService(this, this.sendMsgExecutor)).addService((BindableService)new ConsumerService(this, this.clientMgmtExecutor, this.replyMsgExecutor)).addService((BindableService)new HeartbeatService(this, this.clientMgmtExecutor)).build();
        this.logger.info("GRPCServer[port={}] started", (Object)serverPort);
        this.logger.info("-----------------EventMeshGRPCServer initialized");
    }

    public void start() throws Exception {
        this.logger.info("---------------EventMeshGRPCServer starting-------------------");
        this.producerManager.start();
        this.consumerManager.start();
        this.grpcRetryer.start();
        this.server.start();
        this.logger.info("---------------EventMeshGRPCServer running-------------------");
    }

    public void shutdown() throws Exception {
        this.logger.info("---------------EventMeshGRPCServer stopping-------------------");
        this.producerManager.shutdown();
        this.consumerManager.shutdown();
        this.grpcRetryer.shutdown();
        this.shutdownThreadPools();
        this.shutdownHttpClientPool();
        this.server.shutdown();
        this.logger.info("---------------EventMeshGRPCServer stopped-------------------");
    }

    public EventMeshGrpcConfiguration getEventMeshGrpcConfiguration() {
        return this.eventMeshGrpcConfiguration;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public GrpcRetryer getGrpcRetryer() {
        return this.grpcRetryer;
    }

    public ThreadPoolExecutor getSendMsgExecutor() {
        return this.sendMsgExecutor;
    }

    public ThreadPoolExecutor getClientMgmtExecutor() {
        return this.clientMgmtExecutor;
    }

    public ThreadPoolExecutor getPushMsgExecutor() {
        return this.pushMsgExecutor;
    }

    public RateLimiter getMsgRateLimiter() {
        return this.msgRateLimiter;
    }

    public CloseableHttpClient getHttpClient() {
        int size = this.httpClientPool.size();
        return this.httpClientPool.get(RandomUtils.nextInt((int)size, (int)(2 * size)) % size);
    }

    private void initThreadPool() {
        LinkedBlockingQueue sendMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.eventMeshServerSendMsgBlockQueueSize);
        this.sendMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerSendMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerSendMsgThreadNum, sendMsgThreadPoolQueue, (String)"eventMesh-grpc-sendMsg-%d", (boolean)true);
        LinkedBlockingQueue subscribeMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.eventMeshServerSubscribeMsgBlockQueueSize);
        this.clientMgmtExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerSubscribeMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerSubscribeMsgThreadNum, subscribeMsgThreadPoolQueue, (String)"eventMesh-grpc-clientMgmt-%d", (boolean)true);
        LinkedBlockingQueue pushMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.eventMeshServerPushMsgBlockQueueSize);
        this.pushMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerPushMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerPushMsgThreadNum, pushMsgThreadPoolQueue, (String)"eventMesh-grpc-pushMsg-%d", (boolean)true);
        LinkedBlockingQueue replyMsgThreadPoolQueue = new LinkedBlockingQueue(this.eventMeshGrpcConfiguration.eventMeshServerSendMsgBlockQueueSize);
        this.replyMsgExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshGrpcConfiguration.eventMeshServerReplyMsgThreadNum, (int)this.eventMeshGrpcConfiguration.eventMeshServerReplyMsgThreadNum, sendMsgThreadPoolQueue, (String)"eventMesh-grpc-replyMsg-%d", (boolean)true);
    }

    private void initHttpClientPool() {
        this.httpClientPool = new LinkedList<CloseableHttpClient>();
        for (int i = 0; i < 8; ++i) {
            CloseableHttpClient client = HttpClients.createDefault();
            this.httpClientPool.add(client);
        }
    }

    private void shutdownThreadPools() {
        this.sendMsgExecutor.shutdown();
        this.clientMgmtExecutor.shutdown();
        this.pushMsgExecutor.shutdown();
        this.replyMsgExecutor.shutdown();
    }

    private void shutdownHttpClientPool() {
        Iterator<CloseableHttpClient> itr = this.httpClientPool.iterator();
        while (itr.hasNext()) {
            CloseableHttpClient client = itr.next();
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            itr.remove();
        }
    }
}

