/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.acl;

import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.acl.AclService;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Acl {
    private static final Logger logger = LoggerFactory.getLogger(Acl.class);
    private static AclService aclService;

    public void init(String aclPluginType) throws AclException {
        aclService = (AclService)EventMeshExtensionFactory.getExtension(AclService.class, (String)aclPluginType);
        if (aclService == null) {
            logger.error("can't load the aclService plugin, please check.");
            throw new RuntimeException("doesn't load the aclService plugin, please check.");
        }
        aclService.init();
    }

    public void start() throws AclException {
        aclService.start();
    }

    public void shutdown() throws AclException {
        aclService.shutdown();
    }

    public static void doAclCheckInTcpConnect(String remoteAddr, UserAgent userAgent, int requestCode) throws AclException {
        aclService.doAclCheckInConnect(Acl.buildTcpAclProperties(remoteAddr, userAgent, null, requestCode));
    }

    public static void doAclCheckInTcpHeartbeat(String remoteAddr, UserAgent userAgent, int requestCode) throws AclException {
        aclService.doAclCheckInHeartbeat(Acl.buildTcpAclProperties(remoteAddr, userAgent, null, requestCode));
    }

    public static void doAclCheckInTcpSend(String remoteAddr, UserAgent userAgent, String topic, int requestCode) throws AclException {
        aclService.doAclCheckInSend(Acl.buildTcpAclProperties(remoteAddr, userAgent, topic, requestCode));
    }

    public static void doAclCheckInTcpReceive(String remoteAddr, UserAgent userAgent, String topic, int requestCode) throws AclException {
        aclService.doAclCheckInReceive(Acl.buildTcpAclProperties(remoteAddr, userAgent, topic, requestCode));
    }

    private static Properties buildTcpAclProperties(String remoteAddr, UserAgent userAgent, String topic, int requestCode) {
        Properties aclProperties = new Properties();
        aclProperties.put("clientIp", remoteAddr);
        aclProperties.put("user", userAgent.getUsername());
        aclProperties.put("pwd", userAgent.getPassword());
        aclProperties.put("subsystem", userAgent.getSubsystem());
        aclProperties.put("requestCode", (Object)requestCode);
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            aclProperties.put("topic", topic);
        }
        return aclProperties;
    }

    public static void doAclCheckInHttpSend(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) throws AclException {
        aclService.doAclCheckInSend(Acl.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestCode));
    }

    public static void doAclCheckInHttpReceive(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) throws AclException {
        aclService.doAclCheckInReceive(Acl.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestCode));
    }

    public static void doAclCheckInHttpHeartbeat(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) throws AclException {
        aclService.doAclCheckInHeartbeat(Acl.buildHttpAclProperties(remoteAddr, user, pass, subsystem, topic, requestCode));
    }

    private static Properties buildHttpAclProperties(String remoteAddr, String user, String pass, String subsystem, String topic, int requestCode) {
        Properties aclProperties = new Properties();
        aclProperties.put("clientIp", remoteAddr);
        aclProperties.put("user", user);
        aclProperties.put("pwd", pass);
        aclProperties.put("subsystem", subsystem);
        aclProperties.put("requestCode", (Object)requestCode);
        if (StringUtils.isNotBlank((CharSequence)topic)) {
            aclProperties.put("topic", topic);
        }
        return aclProperties;
    }

    private AclService getSpiAclService() {
        ServiceLoader<AclService> serviceLoader = ServiceLoader.load(AclService.class);
        if (serviceLoader.iterator().hasNext()) {
            return serviceLoader.iterator().next();
        }
        return null;
    }
}

